/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.AbstractController;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.feature.FeatureCollection;
import uk.ac.rdg.resc.edal.geometry.BoundingBox;
import uk.ac.rdg.resc.edal.graphics.formats.ImageFormat;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.Dataset;

public class FrontPageController
extends AbstractController {
    private Config config;

    protected ModelAndView handleRequestInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("config", this.config);
        models.put("supportedImageFormats", ImageFormat.getSupportedMimeTypes());
        HashMap entries = new HashMap();
        for (Dataset dataset : this.config.getAllDatasets().values()) {
            FeatureCollection<? extends Feature> featureCollection = dataset.getFeatureCollection();
            if (featureCollection == null) continue;
            Collection features = featureCollection.getFeatures();
            ArrayList<IndexEntry> layers = new ArrayList<IndexEntry>();
            HashSet<String> used = new HashSet<String>();
            BoundingBox bbox = featureCollection.getCollectionBoundingBox();
            if (features != null) {
                for (Feature feature : features) {
                    List plottableLayers = MetadataUtils.getPlottableLayers((Feature)feature);
                    for (RangeMetadata metadata : plottableLayers) {
                        if (used.contains(metadata.getName())) continue;
                        layers.add(new IndexEntry(metadata, bbox));
                        used.add(metadata.getName());
                    }
                }
            }
            entries.put(dataset, layers);
        }
        models.put("layers", entries);
        return new ModelAndView("index", models);
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public class IndexEntry {
        private RangeMetadata metadata;
        private BoundingBox bbox;

        public IndexEntry(RangeMetadata metadata, BoundingBox bbox) {
            this.metadata = metadata;
            this.bbox = bbox;
        }

        public RangeMetadata getMetadata() {
            return this.metadata;
        }

        public BoundingBox getBbox() {
            return this.bbox;
        }
    }
}

