/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rdg.resc.ncwms.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.multiaction.MultiActionController;
import uk.ac.rdg.resc.edal.Extent;
import uk.ac.rdg.resc.edal.coverage.metadata.RangeMetadata;
import uk.ac.rdg.resc.edal.coverage.metadata.impl.MetadataUtils;
import uk.ac.rdg.resc.edal.feature.Feature;
import uk.ac.rdg.resc.edal.graphics.ColorPalette;
import uk.ac.rdg.resc.edal.util.Extents;
import uk.ac.rdg.resc.ncwms.config.Config;
import uk.ac.rdg.resc.ncwms.config.Contact;
import uk.ac.rdg.resc.ncwms.config.Dataset;
import uk.ac.rdg.resc.ncwms.config.FeaturePlottingMetadata;
import uk.ac.rdg.resc.ncwms.config.Server;

public class AdminController
extends MultiActionController {
    private Config config;

    public ModelAndView displayAdminPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("admin", "config", (Object)this.config);
    }

    public ModelAndView displayDatasetStatusPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("admin_datasetStatus", "dataset", (Object)this.getDataset(request));
    }

    public ModelAndView displayLoadingPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        return new ModelAndView("admin_loading", "dataset", (Object)this.getDataset(request));
    }

    private Dataset getDataset(HttpServletRequest request) throws Exception {
        String datasetId = request.getParameter("dataset");
        if (datasetId == null) {
            throw new Exception("Must provide a dataset id");
        }
        Dataset dataset = this.config.getAllDatasets().get(datasetId);
        if (dataset == null) {
            throw new Exception("There is no dataset with id " + datasetId);
        }
        return dataset;
    }

    public void updateConfig(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Contact contact = this.config.getContact();
        Server server = this.config.getServer();
        if (request.getParameter("contact.name") != null) {
            contact.setName(request.getParameter("contact.name"));
            contact.setOrg(request.getParameter("contact.org"));
            contact.setTel(request.getParameter("contact.tel"));
            contact.setEmail(request.getParameter("contact.email"));
            server.setTitle(request.getParameter("server.title"));
            server.setServerAbstract(request.getParameter("server.abstract"));
            server.setKeywords(request.getParameter("server.keywords"));
            server.setUrl(request.getParameter("server.url"));
            server.setMaxImageWidth(Integer.parseInt(request.getParameter("server.maximagewidth")));
            server.setMaxImageHeight(Integer.parseInt(request.getParameter("server.maximageheight")));
            server.setAllowFeatureInfo(request.getParameter("server.allowfeatureinfo") != null);
            server.setAllowGlobalCapabilities(request.getParameter("server.allowglobalcapabilities") != null);
            ArrayList<Dataset> datasetsToRemove = new ArrayList<Dataset>();
            HashMap<Dataset, String> changedIds = new HashMap<Dataset, String>();
            for (Dataset ds : this.config.getAllDatasets().values()) {
                boolean refreshDataset = false;
                if (request.getParameter("dataset." + ds.getId() + ".remove") != null) {
                    datasetsToRemove.add(ds);
                } else {
                    String newId;
                    boolean disabled;
                    ds.setTitle(request.getParameter("dataset." + ds.getId() + ".title"));
                    String newLocation = request.getParameter("dataset." + ds.getId() + ".location");
                    if (!newLocation.trim().equals(ds.getLocation().trim())) {
                        refreshDataset = true;
                    }
                    ds.setLocation(newLocation);
                    String newDataReaderClass = request.getParameter("dataset." + ds.getId() + ".reader");
                    if (!newDataReaderClass.trim().equals(ds.getDataReaderClass().trim())) {
                        refreshDataset = true;
                    }
                    ds.setDataReaderClass(newDataReaderClass);
                    boolean bl = disabled = request.getParameter("dataset." + ds.getId() + ".disabled") != null;
                    if (!disabled && ds.isDisabled()) {
                        refreshDataset = true;
                    }
                    ds.setDisabled(disabled);
                    ds.setQueryable(request.getParameter("dataset." + ds.getId() + ".queryable") != null);
                    ds.setUpdateInterval(Integer.parseInt(request.getParameter("dataset." + ds.getId() + ".updateinterval")));
                    ds.setMoreInfo(request.getParameter("dataset." + ds.getId() + ".moreinfo"));
                    ds.setCopyrightStatement(request.getParameter("dataset." + ds.getId() + ".copyright"));
                    if (request.getParameter("dataset." + ds.getId() + ".refresh") != null) {
                        refreshDataset = true;
                    }
                    if (!(newId = request.getParameter("dataset." + ds.getId() + ".id").trim()).equals(ds.getId())) {
                        changedIds.put(ds, newId);
                    }
                }
                if (!refreshDataset) continue;
                ds.forceRefresh();
            }
            for (Dataset ds : datasetsToRemove) {
                this.config.removeDataset(ds);
            }
            for (Dataset ds : changedIds.keySet()) {
                this.config.changeDatasetId(ds, (String)changedIds.get(ds));
                ds.forceRefresh();
            }
            int i = 0;
            while (request.getParameter("dataset.new" + i + ".id") != null) {
                if (!request.getParameter("dataset.new" + i + ".id").trim().equals("")) {
                    Dataset ds;
                    ds = new Dataset();
                    ds.setId(request.getParameter("dataset.new" + i + ".id"));
                    ds.setTitle(request.getParameter("dataset.new" + i + ".title"));
                    ds.setLocation(request.getParameter("dataset.new" + i + ".location"));
                    ds.setDataReaderClass(request.getParameter("dataset.new" + i + ".reader"));
                    ds.setDisabled(request.getParameter("dataset.new" + i + ".disabled") != null);
                    ds.setQueryable(request.getParameter("dataset.new" + i + ".queryable") != null);
                    ds.setUpdateInterval(Integer.parseInt(request.getParameter("dataset.new" + i + ".updateinterval")));
                    ds.setMoreInfo(request.getParameter("dataset.new" + i + ".moreinfo"));
                    ds.setCopyrightStatement(request.getParameter("dataset.new" + i + ".copyright"));
                    this.config.addDataset(ds);
                }
                ++i;
            }
            this.config.getCache().setEnabled(request.getParameter("cache.enable") != null);
            this.config.getCache().setElementLifetimeMinutes(Integer.parseInt(request.getParameter("cache.elementLifetime")));
            this.config.getCache().setMaxNumItemsInMemory(Integer.parseInt(request.getParameter("cache.maxNumItemsInMemory")));
            this.config.getCache().setEnableDiskStore(request.getParameter("cache.enableDiskStore") != null);
            this.config.getCache().setMaxNumItemsOnDisk(Integer.parseInt(request.getParameter("cache.maxNumItemsOnDisk")));
            String newThreddsCatalogLocation = request.getParameter("thredds.catalog.location");
            if (!this.config.getThreddsCatalogLocation().trim().equals(newThreddsCatalogLocation)) {
                this.config.setThreddsCatalogLocation(newThreddsCatalogLocation);
            }
            this.config.save();
        }
        response.sendRedirect("index.jsp");
    }

    public ModelAndView displayEditVariablesPage(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String datasetID = request.getParameter("dataset");
        if (datasetID == null) {
            throw new Exception("Must specify a dataset id");
        }
        Dataset ds = this.config.getAllDatasets().get(datasetID);
        if (ds == null) {
            throw new Exception("Must specify a valid dataset id");
        }
        if (!ds.isReady()) {
            throw new Exception("Dataset must be ready before its variables can be edited");
        }
        HashMap<String, Object> models = new HashMap<String, Object>();
        models.put("dataset", ds);
        models.put("paletteNames", ColorPalette.getAvailablePaletteNames());
        return new ModelAndView("editVariables", models);
    }

    public void updateVariables(HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (request.getParameter("save") != null) {
            Dataset ds = this.config.getAllDatasets().get(request.getParameter("dataset.id"));
            HashSet<String> layerIds = new HashSet<String>();
            Enumeration parameterNames = request.getParameterNames();
            while (parameterNames.hasMoreElements()) {
                String parameterName = (String)parameterNames.nextElement();
                String[] parts = parameterName.split("\\.");
                if (parts.length != 2 || parts[0].equals("dataset")) continue;
                layerIds.add(parts[0]);
            }
            for (String layerId : layerIds) {
                String newTitle = request.getParameter(layerId + ".title").trim();
                float min = Float.parseFloat(request.getParameter(layerId + ".scaleMin").trim());
                float max = Float.parseFloat(request.getParameter(layerId + ".scaleMax").trim());
                FeaturePlottingMetadata var = ds.getPlottingMetadataMap().get(layerId);
                var.setTitle(newTitle);
                var.setColorScaleRange((Extent<Float>)Extents.newExtent((Object)Float.valueOf(min), (Object)Float.valueOf(max)));
                var.setPaletteName(request.getParameter(layerId + ".palette"));
                var.setNumColorBands(Integer.parseInt(request.getParameter(layerId + ".numColorBands")));
                var.setScaling(request.getParameter(layerId + ".scaling"));
                String[] layerParts = layerId.split("/");
                if (layerParts.length != 2) continue;
                if (layerParts[0].equals("*")) {
                    Collection features = ds.getFeatureCollection().getFeatures();
                    if (features == null) continue;
                    for (Feature feature : features) {
                        RangeMetadata memberMetadata = MetadataUtils.getMetadataForFeatureMember((Feature)feature, (String)layerParts[1]);
                        memberMetadata.setTitle(newTitle);
                    }
                    continue;
                }
                Feature feature = ds.getFeatureById(layerParts[0]);
                if (feature == null) continue;
                RangeMetadata memberMetadata = MetadataUtils.getMetadataForFeatureMember((Feature)feature, (String)layerParts[1]);
                memberMetadata.setTitle(newTitle);
            }
            this.config.save();
        }
        response.sendRedirect("index.jsp");
    }

    public void setConfig(Config config) {
        this.config = config;
    }
}

