/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.bind.impl;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.zkoss.bind.BindContext;
import org.zkoss.bind.Binder;
import org.zkoss.bind.Converter;
import org.zkoss.bind.impl.PropertyBindingImpl;
import org.zkoss.bind.sys.BindEvaluatorX;
import org.zkoss.bind.sys.BinderCtrl;
import org.zkoss.bind.sys.ConditionType;
import org.zkoss.bind.sys.LoadPropertyBinding;
import org.zkoss.bind.xel.zel.BindELContext;
import org.zkoss.lang.Classes;
import org.zkoss.zk.ui.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadPropertyBindingImpl
extends PropertyBindingImpl
implements LoadPropertyBinding {
    private static final long serialVersionUID = 1463169907348730644L;
    private final Set<String> _doneDependsOn = new HashSet<String>(4);
    private final Class<?> _attrType;

    public LoadPropertyBindingImpl(Binder binder, Component comp, String attr, String loadAttr, Class<?> attrType, String loadExpr, ConditionType conditionType, String command, Map<String, Object> bindingArgs, String converterExpr, Map<String, Object> converterArgs) {
        super(binder, comp, attr, "self." + loadAttr, loadExpr, conditionType, command, bindingArgs, converterExpr, converterArgs);
        this._attrType = attrType == null ? Object.class : attrType;
    }

    @Override
    public void load(BindContext ctx) {
        Component comp = this.getComponent();
        BindEvaluatorX eval = this.getBinder().getEvaluatorX();
        Object value = eval.getValue(ctx, comp, this._accessInfo.getProperty());
        boolean activating = ((BinderCtrl)((Object)this.getBinder())).isActivating();
        Converter conv = this.getConverter();
        if (conv != null) {
            if (activating) {
                return;
            }
            if ((value = conv.coerceToUi(value, comp, ctx)) == Converter.IGNORED_VALUE) {
                return;
            }
        }
        if (activating) {
            return;
        }
        value = Classes.coerce(this._attrType, (Object)value);
        eval.setValue(null, comp, this._fieldExpr, value);
    }

    private Method getConverterMethod(Class<? extends Converter> cls) {
        try {
            return cls.getMethod("coerceToUi", Object.class, Component.class, BindContext.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return null;
        }
    }

    public void addDependsOnTrackings(List<String> srcpath, String basepath, String[] props) {
        if (srcpath != null) {
            String src = BindELContext.pathToString(srcpath);
            if (this._doneDependsOn.contains(src)) {
                return;
            }
            this._doneDependsOn.add(src);
        }
        for (String prop : props) {
            BindELContext.addDependsOnTracking(this, srcpath, basepath, prop);
        }
    }
}

