/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.zeroturnaround.zip.FileSource;
import org.zeroturnaround.zip.NameMapper;
import org.zeroturnaround.zip.ZTFileUtil;
import org.zeroturnaround.zip.ZipBreakException;
import org.zeroturnaround.zip.ZipEntryCallback;
import org.zeroturnaround.zip.ZipEntryOrInfoAdapter;
import org.zeroturnaround.zip.ZipEntrySource;
import org.zeroturnaround.zip.ZipEntryUtil;
import org.zeroturnaround.zip.ZipExceptionUtil;
import org.zeroturnaround.zip.ZipFileUtil;
import org.zeroturnaround.zip.ZipInfoCallback;
import org.zeroturnaround.zip.ZipUtil;
import org.zeroturnaround.zip.commons.FileUtils;
import org.zeroturnaround.zip.commons.IOUtils;
import org.zeroturnaround.zip.transform.ZipEntryTransformer;
import org.zeroturnaround.zip.transform.ZipEntryTransformerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Zips {
    private final File src;
    private File dest;
    private Charset charset;
    private boolean preserveTimestamps;
    private List<ZipEntrySource> changedEntries = new ArrayList<ZipEntrySource>();
    private Set<String> removedEntries = new HashSet<String>();
    private List<ZipEntryTransformerEntry> transformers = new ArrayList<ZipEntryTransformerEntry>();
    private NameMapper nameMapper;
    private boolean unpackedResult;

    private Zips(File src) {
        this.src = src;
    }

    public static Zips get(File src) {
        return new Zips(src);
    }

    public static Zips create() {
        return new Zips(null);
    }

    public Zips addEntry(ZipEntrySource entry) {
        this.changedEntries.add(entry);
        return this;
    }

    public Zips addEntries(ZipEntrySource[] entries) {
        this.changedEntries.addAll(Arrays.asList(entries));
        return this;
    }

    public Zips addFile(File file) {
        return this.addFile(file, false, null);
    }

    public Zips addFile(File file, boolean preserveRoot) {
        return this.addFile(file, preserveRoot, null);
    }

    public Zips addFile(File file, FileFilter filter) {
        return this.addFile(file, false, filter);
    }

    public Zips addFile(File file, boolean preserveRoot, FileFilter filter) {
        if (!file.isDirectory()) {
            this.changedEntries.add(new FileSource(file.getName(), file));
            return this;
        }
        Collection<File> files = ZTFileUtil.listFiles(file);
        for (File entryFile : files) {
            if (filter != null && !filter.accept(entryFile)) continue;
            String entryPath = this.getRelativePath(file, entryFile);
            if (File.separator.equals("\\")) {
                entryPath = entryPath.replace('\\', '/');
            }
            if (preserveRoot) {
                entryPath = file.getName() + entryPath;
            }
            if (entryPath.startsWith("/")) {
                entryPath = entryPath.substring(1);
            }
            this.changedEntries.add(new FileSource(entryPath, entryFile));
        }
        return this;
    }

    private String getRelativePath(File parent, File file) {
        String parentPath = parent.getPath();
        String filePath = file.getPath();
        if (!filePath.startsWith(parentPath)) {
            throw new IllegalArgumentException("File " + file + " is not a child of " + parent);
        }
        return filePath.substring(parentPath.length());
    }

    public Zips removeEntry(String entry) {
        this.removedEntries.add(entry);
        return this;
    }

    public Zips removeEntries(String[] entries) {
        this.removedEntries.addAll(Arrays.asList(entries));
        return this;
    }

    public Zips preserveTimestamps() {
        this.preserveTimestamps = true;
        return this;
    }

    public Zips setPreserveTimestamps(boolean preserve) {
        this.preserveTimestamps = preserve;
        return this;
    }

    public Zips charset(Charset charset) {
        this.charset = charset;
        return this;
    }

    public Zips destination(File destination) {
        this.dest = destination;
        return this;
    }

    public Zips nameMapper(NameMapper nameMapper) {
        this.nameMapper = nameMapper;
        return this;
    }

    public Zips unpack() {
        this.unpackedResult = true;
        return this;
    }

    private boolean isInPlace() {
        return this.dest == null;
    }

    private boolean isUnpack() {
        return this.unpackedResult || this.dest != null && this.dest.isDirectory();
    }

    public Zips addTransformer(String path, ZipEntryTransformer transformer) {
        this.transformers.add(new ZipEntryTransformerEntry(path, transformer));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        if (this.src == null && this.dest == null) {
            throw new IllegalArgumentException("Source and destination shouldn't be null together");
        }
        File destinationFile = null;
        try {
            destinationFile = this.getDestinationFile();
            ZipOutputStream out = null;
            ZipEntryOrInfoAdapter zipEntryAdapter = null;
            if (destinationFile.isFile()) {
                out = ZipFileUtil.createZipOutputStream(new BufferedOutputStream(new FileOutputStream(destinationFile)), this.charset);
                zipEntryAdapter = new ZipEntryOrInfoAdapter(new CopyingCallback(this.transformers, out, this.preserveTimestamps), null);
            } else {
                zipEntryAdapter = new ZipEntryOrInfoAdapter(new UnpackingCallback(this.transformers, destinationFile), null);
            }
            try {
                this.processAllEntries(zipEntryAdapter);
            }
            finally {
                IOUtils.closeQuietly(out);
            }
            this.handleInPlaceActions(destinationFile);
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
        }
        finally {
            if (this.isInPlace()) {
                FileUtils.deleteQuietly(destinationFile);
            }
        }
    }

    private void processAllEntries(ZipEntryOrInfoAdapter zipEntryAdapter) {
        this.iterateChangedAndAdded(zipEntryAdapter);
        this.iterateExistingExceptRemoved(zipEntryAdapter);
    }

    private File getDestinationFile() throws IOException {
        if (this.isUnpack()) {
            if (this.isInPlace()) {
                File tempFile = File.createTempFile("zips", null);
                FileUtils.deleteQuietly(tempFile);
                tempFile.mkdirs();
                return tempFile;
            }
            if (!this.dest.isDirectory()) {
                FileUtils.deleteQuietly(this.dest);
                File result = new File(this.dest.getAbsolutePath());
                result.mkdirs();
                return result;
            }
            return this.dest;
        }
        if (this.isInPlace()) {
            return File.createTempFile("zips", ".zip");
        }
        if (this.dest.isDirectory()) {
            FileUtils.deleteQuietly(this.dest);
            return new File(this.dest.getAbsolutePath());
        }
        return this.dest;
    }

    public void iterate(ZipEntryCallback zipEntryCallback) {
        ZipEntryOrInfoAdapter zipEntryAdapter = new ZipEntryOrInfoAdapter(zipEntryCallback, null);
        this.processAllEntries(zipEntryAdapter);
    }

    public void iterate(ZipInfoCallback callback) {
        ZipEntryOrInfoAdapter zipEntryAdapter = new ZipEntryOrInfoAdapter(null, callback);
        this.processAllEntries(zipEntryAdapter);
    }

    public byte[] getEntry(String name) {
        if (this.src == null) {
            throw new IllegalStateException("Source is not given");
        }
        return ZipUtil.unpackEntry(this.src, name);
    }

    public boolean containsEntry(String name) {
        if (this.src == null) {
            throw new IllegalStateException("Source is not given");
        }
        return ZipUtil.containsEntry(this.src, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void iterateExistingExceptRemoved(ZipEntryOrInfoAdapter zipEntryCallback) {
        if (this.src == null) {
            return;
        }
        Set<String> removedDirs = ZipUtil.filterDirEntries(this.src, this.removedEntries);
        ZipFile zf = null;
        try {
            zf = this.getZipFile();
            Enumeration<? extends ZipEntry> en = zf.entries();
            while (en.hasMoreElements()) {
                ZipEntry entry = en.nextElement();
                String entryName = entry.getName();
                if (this.removedEntries.contains(entryName) || this.isEntryInDir(removedDirs, entryName)) continue;
                if (this.nameMapper != null) {
                    String mappedName = this.nameMapper.map(entry.getName());
                    if (mappedName == null) continue;
                    if (!mappedName.equals(entry.getName())) {
                        entry = ZipEntryUtil.copy(entry, mappedName);
                    }
                }
                InputStream is = zf.getInputStream(entry);
                try {
                    zipEntryCallback.process(is, entry);
                }
                catch (ZipBreakException ex) {
                    return;
                }
                finally {
                    IOUtils.closeQuietly(is);
                }
            }
            return;
        }
        catch (IOException e) {
            ZipExceptionUtil.rethrow(e);
            return;
        }
        finally {
            ZipUtil.closeQuietly(zf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void iterateChangedAndAdded(ZipEntryOrInfoAdapter zipEntryCallback) {
        for (ZipEntrySource entrySource : this.changedEntries) {
            InputStream entrySourceStream = null;
            try {
                ZipEntry entry = entrySource.getEntry();
                if (this.nameMapper != null) {
                    String mappedName = this.nameMapper.map(entry.getName());
                    if (mappedName == null) {
                        IOUtils.closeQuietly(entrySourceStream);
                        continue;
                    }
                    if (!mappedName.equals(entry.getName())) {
                        entry = ZipEntryUtil.copy(entry, mappedName);
                    }
                }
                entrySourceStream = entrySource.getInputStream();
                zipEntryCallback.process(entrySourceStream, entry);
                IOUtils.closeQuietly(entrySourceStream);
            }
            catch (ZipBreakException ex) {
                IOUtils.closeQuietly(entrySourceStream);
                break;
            }
            catch (IOException e) {
                ZipExceptionUtil.rethrow(e);
            }
            finally {
                IOUtils.closeQuietly(entrySourceStream);
            }
        }
    }

    private void handleInPlaceActions(File result) throws IOException {
        if (this.isInPlace()) {
            FileUtils.forceDelete(this.src);
            if (result.isFile()) {
                FileUtils.moveFile(result, this.src);
            } else {
                FileUtils.moveDirectory(result, this.src);
            }
        }
    }

    private boolean isEntryInDir(Set<String> dirNames, String entryName) {
        for (String dirName : dirNames) {
            if (!entryName.startsWith(dirName)) continue;
            return true;
        }
        return false;
    }

    private ZipFile getZipFile() throws IOException {
        return ZipFileUtil.getZipFile(this.src, this.charset);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UnpackingCallback
    implements ZipEntryCallback {
        private final Map<String, ZipEntryTransformer> entryByPath;
        private final Set<String> visitedNames;
        private final File destination;

        private UnpackingCallback(List<ZipEntryTransformerEntry> entries, File destination) {
            this.destination = destination;
            this.entryByPath = ZipUtil.transformersByPath(entries);
            this.visitedNames = new HashSet<String>();
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String entryName = zipEntry.getName();
            if (this.visitedNames.contains(entryName)) {
                return;
            }
            this.visitedNames.add(entryName);
            File file = new File(this.destination, entryName);
            if (zipEntry.isDirectory()) {
                FileUtils.forceMkdir(file);
                return;
            }
            FileUtils.forceMkdir(file.getParentFile());
            file.createNewFile();
            ZipEntryTransformer transformer = this.entryByPath.remove(entryName);
            if (transformer == null) {
                FileUtils.copy(in, file);
            } else {
                this.transformIntoFile(transformer, in, zipEntry, file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transformIntoFile(final ZipEntryTransformer transformer, final InputStream entryIn, final ZipEntry zipEntry, File destination) throws IOException {
            PipedInputStream pipedIn = new PipedInputStream();
            PipedOutputStream pipedOut = new PipedOutputStream(pipedIn);
            final ZipOutputStream zipOut = new ZipOutputStream(pipedOut);
            ZipInputStream zipIn = new ZipInputStream(pipedIn);
            ExecutorService newFixedThreadPool = Executors.newFixedThreadPool(1);
            try {
                newFixedThreadPool.execute(new Runnable(){

                    public void run() {
                        try {
                            transformer.transform(entryIn, zipEntry, zipOut);
                        }
                        catch (IOException e) {
                            ZipExceptionUtil.rethrow(e);
                        }
                    }
                });
                zipIn.getNextEntry();
                FileUtils.copy(zipIn, destination);
            }
            finally {
                try {
                    zipIn.closeEntry();
                }
                catch (IOException iOException) {}
                newFixedThreadPool.shutdown();
                IOUtils.closeQuietly(pipedIn);
                IOUtils.closeQuietly(zipIn);
                IOUtils.closeQuietly(pipedOut);
                IOUtils.closeQuietly(zipOut);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CopyingCallback
    implements ZipEntryCallback {
        private final Map<String, ZipEntryTransformer> entryByPath;
        private final ZipOutputStream out;
        private final Set<String> visitedNames;
        private final boolean preserveTimestapms;

        private CopyingCallback(List<ZipEntryTransformerEntry> transformerEntries, ZipOutputStream out, boolean preserveTimestapms) {
            this.out = out;
            this.preserveTimestapms = preserveTimestapms;
            this.entryByPath = ZipUtil.transformersByPath(transformerEntries);
            this.visitedNames = new HashSet<String>();
        }

        @Override
        public void process(InputStream in, ZipEntry zipEntry) throws IOException {
            String entryName = zipEntry.getName();
            if (this.visitedNames.contains(entryName)) {
                return;
            }
            this.visitedNames.add(entryName);
            ZipEntryTransformer transformer = this.entryByPath.remove(entryName);
            if (transformer == null) {
                ZipEntryUtil.copyEntry(zipEntry, in, this.out, this.preserveTimestapms);
            } else {
                transformer.transform(in, zipEntry, this.out);
            }
        }
    }
}

