/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.zip;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import org.zeroturnaround.zip.ZipEntrySource;

public class ByteSource
implements ZipEntrySource {
    private final String path;
    private final byte[] bytes;
    private final long time;
    private final int compressionLevel;
    private final long crc;

    public ByteSource(String path, byte[] bytes) {
        this(path, bytes, System.currentTimeMillis());
    }

    public ByteSource(String path, byte[] bytes, long time) {
        this(path, bytes, time, -1);
    }

    public ByteSource(String path, byte[] bytes, int compressionLevel) {
        this(path, bytes, System.currentTimeMillis(), compressionLevel);
    }

    public ByteSource(String path, byte[] bytes, long time, int compressionLevel) {
        this.path = path;
        this.bytes = (byte[])bytes.clone();
        this.time = time;
        this.compressionLevel = compressionLevel;
        if (compressionLevel != -1) {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes);
            this.crc = crc32.getValue();
        } else {
            this.crc = -1L;
        }
    }

    public String getPath() {
        return this.path;
    }

    public ZipEntry getEntry() {
        ZipEntry entry = new ZipEntry(this.path);
        if (this.bytes != null) {
            entry.setSize(this.bytes.length);
        }
        if (this.compressionLevel != -1) {
            entry.setMethod(this.compressionLevel);
        }
        if (this.crc != -1L) {
            entry.setCrc(this.crc);
        }
        entry.setTime(this.time);
        return entry;
    }

    public InputStream getInputStream() throws IOException {
        if (this.bytes == null) {
            return null;
        }
        return new ByteArrayInputStream(this.bytes);
    }

    public String toString() {
        return "ByteSource[" + this.path + "]";
    }
}

