/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.concurrent.atomic.AtomicInteger;
import zmq.YQueue;

public class YPipe<T> {
    private final YQueue<T> queue;
    private int w;
    private int r;
    private int f;
    private final AtomicInteger c;

    public YPipe(int qsize) {
        int pos;
        this.queue = new YQueue(qsize);
        this.f = pos = this.queue.backPos();
        this.r = pos;
        this.w = pos;
        this.c = new AtomicInteger(pos);
    }

    public void write(T value, boolean incomplete) {
        this.queue.push(value);
        if (!incomplete) {
            this.f = this.queue.backPos();
        }
    }

    public T unwrite() {
        if (this.f == this.queue.backPos()) {
            return null;
        }
        this.queue.unpush();
        return this.queue.back();
    }

    public boolean flush() {
        if (this.w == this.f) {
            return true;
        }
        if (!this.c.compareAndSet(this.w, this.f)) {
            this.c.set(this.f);
            this.w = this.f;
            return false;
        }
        this.w = this.f;
        return true;
    }

    public boolean checkRead() {
        int h = this.queue.frontPos();
        if (h != this.r) {
            return true;
        }
        if (!this.c.compareAndSet(h, -1)) {
            this.r = this.c.get();
        }
        return h != this.r && this.r != -1;
    }

    public T read() {
        if (!this.checkRead()) {
            return null;
        }
        return this.queue.pop();
    }

    public T probe() {
        boolean rc = this.checkRead();
        assert (rc);
        return this.queue.front();
    }
}

