/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.nio.ByteBuffer;
import zmq.IDecoder;
import zmq.Msg;
import zmq.MsgAllocator;
import zmq.MsgAllocatorHeap;

public abstract class DecoderBase
implements IDecoder {
    private ByteBuffer readBuf;
    private MsgAllocator msgAllocator = new MsgAllocatorHeap();
    private int bufsize;
    private ByteBuffer buf;
    private int state = -1;
    boolean zeroCopy;

    public DecoderBase(int bufsize) {
        this.bufsize = bufsize;
        if (bufsize > 0) {
            this.buf = ByteBuffer.allocateDirect(bufsize);
        }
        this.readBuf = null;
        this.zeroCopy = false;
    }

    @Override
    public ByteBuffer getBuffer() {
        if (this.readBuf.remaining() >= this.bufsize) {
            this.zeroCopy = true;
            return this.readBuf.duplicate();
        }
        this.zeroCopy = false;
        this.buf.clear();
        return this.buf;
    }

    @Override
    public int processBuffer(ByteBuffer buf, int size) {
        if (this.state() < 0) {
            return -1;
        }
        if (this.zeroCopy) {
            this.readBuf.position(this.readBuf.position() + size);
            while (this.readBuf.remaining() == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return size;
            }
            return size;
        }
        int pos = 0;
        while (true) {
            if (this.readBuf.remaining() == 0) {
                if (this.next()) continue;
                if (this.state() < 0) {
                    return -1;
                }
                return pos;
            }
            if (pos == size) {
                return pos;
            }
            int toCopy = Math.min(this.readBuf.remaining(), size - pos);
            int limit = buf.limit();
            buf.limit(buf.position() + toCopy);
            this.readBuf.put(buf);
            buf.limit(limit);
            pos += toCopy;
        }
    }

    protected void nextStep(Msg msg, int state) {
        this.nextStep(msg.buf(), state);
    }

    protected void nextStep(byte[] buf, int toRead, int state) {
        this.readBuf = ByteBuffer.wrap(buf);
        this.readBuf.limit(toRead);
        this.state = state;
    }

    protected void nextStep(ByteBuffer buf, int state) {
        this.readBuf = buf;
        this.state = state;
    }

    protected int state() {
        return this.state;
    }

    protected void state(int state) {
        this.state = state;
    }

    protected void decodingError() {
        this.state(-1);
    }

    @Override
    public boolean stalled() {
        if (!this.next()) {
            return false;
        }
        while (this.readBuf.remaining() == 0) {
            if (this.next()) continue;
            return this.next();
        }
        return false;
    }

    public MsgAllocator getMsgAllocator() {
        return this.msgAllocator;
    }

    public void setMsgAllocator(MsgAllocator msgAllocator) {
        this.msgAllocator = msgAllocator;
    }

    protected abstract boolean next();
}

