/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.utils;

import java.io.IOException;
import java.io.InputStream;

public final class InformationInputStream
extends InputStream {
    private final InputStream inputStream;
    private final char[] shell_utf8 = new char[]{'#', '!'};
    private final char[] shell_utf16be = new char[]{'\u0000', '#', '\u0000', '!'};
    private final char[] shell_utf16le = new char[]{'#', '\u0000', '!', '\u0000'};
    private final char[] bom1 = new char[]{'\u00ef', '\u00bb', '\u00bf'};
    private final char[] bom2 = new char[]{'\u00ff', '\u00fe'};
    private final char[] bom3 = new char[]{'\u00fe', '\u00ff'};
    private int shell_utf8_i;
    private int shell_utf16be_i;
    private int shell_utf16le_i;
    private int bom1_i;
    private int bom2_i;
    private int bom3_i;
    private long i;
    private long ascii;
    private long nonascii;
    private long cr;
    private long lf;
    private long zero;
    private BOM bom = BOM.NONE;
    private SHELL shell = SHELL.NONE;

    public InformationInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean hasBom() {
        return this.bom != BOM.NONE;
    }

    public boolean isShell() {
        return this.shell != SHELL.NONE;
    }

    public boolean hasUnixLineEndings() {
        return this.cr == 0L;
    }

    private void add(int c) {
        if (this.i < 10L) {
            if (this.shell == SHELL.NONE) {
                if (this.shell_utf8_i < this.shell_utf8.length) {
                    this.shell_utf8_i = c == this.shell_utf8[this.shell_utf8_i] ? ++this.shell_utf8_i : 0;
                } else {
                    this.shell = SHELL.UTF8;
                }
                if (this.shell_utf16be_i < this.shell_utf16be.length) {
                    this.shell_utf16be_i = c == this.shell_utf16be[this.shell_utf16be_i] ? ++this.shell_utf16be_i : 0;
                } else {
                    this.shell = SHELL.UTF16BE;
                }
                if (this.shell_utf16le_i < this.shell_utf16le.length) {
                    this.shell_utf16le_i = c == this.shell_utf16le[this.shell_utf16le_i] ? ++this.shell_utf16le_i : 0;
                } else {
                    this.shell = SHELL.UTF16LE;
                }
            }
            if (this.bom == BOM.NONE) {
                if (this.bom1_i < this.bom1.length) {
                    this.bom1_i = c == this.bom1[this.bom1_i] && (long)this.bom1_i == this.i ? ++this.bom1_i : 0;
                } else {
                    this.bom = BOM.BOM1;
                }
                if (this.bom2_i < this.bom2.length) {
                    this.bom2_i = c == this.bom2[this.bom2_i] && (long)this.bom2_i == this.i ? ++this.bom2_i : 0;
                } else {
                    this.bom = BOM.BOM2;
                }
                if (this.bom3_i < this.bom3.length) {
                    this.bom3_i = c == this.bom3[this.bom3_i] && (long)this.bom3_i == this.i ? ++this.bom3_i : 0;
                } else {
                    this.bom = BOM.BOM3;
                }
            }
        }
        ++this.i;
        if (c == 10) {
            ++this.lf;
            return;
        }
        if (c == 13) {
            ++this.cr;
            return;
        }
        if (c >= 32 && c <= 126) {
            ++this.ascii;
            return;
        }
        if (c == 0) {
            ++this.zero;
            return;
        }
        ++this.nonascii;
    }

    @Override
    public int available() throws IOException {
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public void mark(int readlimit) {
        this.inputStream.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.inputStream.markSupported();
    }

    @Override
    public int read() throws IOException {
        int ret = this.inputStream.read();
        if (ret != -1) {
            this.add(ret & 0xFF);
        }
        return ret;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int ret = this.inputStream.read(b, off, len);
        for (int i = 0; i < ret; ++i) {
            this.add(b[off + i] & 0xFF);
        }
        return ret;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public void reset() throws IOException {
        this.inputStream.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.inputStream.skip(n);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append("total=").append(this.i);
        sb.append(",noascii=").append(this.nonascii);
        sb.append(",ascii=").append(this.ascii);
        sb.append(",cr=").append(this.cr);
        sb.append(",lf=").append(this.lf);
        sb.append(",zero=").append(this.zero);
        sb.append("}");
        return sb.toString();
    }

    private static enum SHELL {
        NONE,
        UTF8,
        UTF16BE,
        UTF16LE;

    }

    private static enum BOM {
        NONE,
        BOM1,
        BOM2,
        BOM3;

    }
}

