/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.shaded.compress.compress.compressors.gzip;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorInputStream;

public class GzipCompressorInputStream
extends CompressorInputStream {
    private final GZIPInputStream in;

    public GzipCompressorInputStream(InputStream inputStream) throws IOException {
        this.in = new GZIPInputStream(inputStream);
    }

    public int read() throws IOException {
        int read = this.in.read();
        this.count(read < 0 ? -1 : 1);
        return read;
    }

    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        this.count(read);
        return read;
    }

    public int read(byte[] b, int from, int length) throws IOException {
        int read = this.in.read(b, from, length);
        this.count(read);
        return read;
    }

    public static boolean matches(byte[] signature, int length) {
        if (length < 2) {
            return false;
        }
        if (signature[0] != 31) {
            return false;
        }
        return signature[1] == -117;
    }

    public void close() throws IOException {
        if (this.in != System.in) {
            this.in.close();
        }
    }
}

