/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.producers;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.tools.tar.TarEntry;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.mapping.Mapper;
import org.vafer.jdeb.producers.AbstractDataProducer;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveException;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveInputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.ArchiveStreamFactory;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.tar.TarArchiveInputStream;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveEntry;
import org.vafer.jdeb.shaded.compress.compress.archivers.zip.ZipArchiveInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorException;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorInputStream;
import org.vafer.jdeb.shaded.compress.compress.compressors.CompressorStreamFactory;

public final class DataProducerArchive
extends AbstractDataProducer
implements DataProducer {
    private final File archive;

    public DataProducerArchive(File pArchive, String[] pIncludes, String[] pExcludes, Mapper[] pMappers) {
        super(pIncludes, pExcludes, pMappers);
        this.archive = pArchive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(this.archive));
        CompressorInputStream compressorInputStream = null;
        try {
            compressorInputStream = new CompressorStreamFactory().createCompressorInputStream(is);
        }
        catch (CompressorException e) {
            throw new IOException("Unsupported compression format: " + this.archive, e);
        }
        if (compressorInputStream != null) {
            is = new BufferedInputStream(compressorInputStream);
        }
        ArchiveInputStream archiveInputStream = null;
        try {
            archiveInputStream = new ArchiveStreamFactory().createArchiveInputStream(is);
        }
        catch (ArchiveException e) {
            throw new IOException("Unsupported archive format: " + this.archive, e);
        }
        EntryConverter converter = null;
        if (archiveInputStream instanceof TarArchiveInputStream) {
            converter = new EntryConverter(){

                @Override
                public TarEntry convert(ArchiveEntry entry) {
                    TarArchiveEntry src = (TarArchiveEntry)entry;
                    TarEntry dst = new TarEntry(src.getName());
                    dst.setSize(src.getSize());
                    dst.setGroupName(src.getGroupName());
                    dst.setGroupId(src.getGroupId());
                    dst.setUserId(src.getUserId());
                    dst.setMode(src.getMode());
                    dst.setModTime(src.getModTime());
                    return dst;
                }
            };
        } else if (archiveInputStream instanceof ZipArchiveInputStream) {
            converter = new EntryConverter(){

                @Override
                public TarEntry convert(ArchiveEntry entry) {
                    ZipArchiveEntry src = (ZipArchiveEntry)entry;
                    TarEntry dst = new TarEntry(src.getName());
                    dst.setSize(src.getSize());
                    dst.setMode(src.getUnixMode());
                    dst.setModTime(src.getTime());
                    return dst;
                }
            };
        } else {
            throw new IOException("Unsupported archive format: " + this.archive);
        }
        try {
            ArchiveEntry archiveEntry;
            while ((archiveEntry = archiveInputStream.getNextEntry()) != null) {
                if (!this.isIncluded(archiveEntry.getName())) continue;
                TarEntry entry = converter.convert(archiveEntry);
                if ((entry = this.map(entry)).isDirectory()) {
                    pReceiver.onEachDir(entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
                    continue;
                }
                pReceiver.onEachFile(archiveInputStream, entry.getName(), entry.getLinkName(), entry.getUserName(), entry.getUserId(), entry.getGroupName(), entry.getGroupId(), entry.getMode(), entry.getSize());
            }
        }
        finally {
            if (archiveInputStream != null) {
                archiveInputStream.close();
            }
        }
    }

    private static interface EntryConverter {
        public TarEntry convert(ArchiveEntry var1);
    }
}

