/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileInputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProjectHelper;
import org.vafer.jdeb.Console;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.PackagingException;
import org.vafer.jdeb.descriptors.AbstractDescriptor;
import org.vafer.jdeb.maven.AbstractPluginMojo;
import org.vafer.jdeb.maven.Data;
import org.vafer.jdeb.maven.DebMaker;
import org.vafer.jdeb.utils.MapVariableResolver;
import org.vafer.jdeb.utils.Utils;
import org.vafer.jdeb.utils.VariableResolver;

public class DebMojo
extends AbstractPluginMojo {
    private MavenProjectHelper projectHelper;
    private String deb;
    private String controlDir;
    private String changesIn;
    private String changesOut;
    private String changesSave;
    private String compression;
    private String attach;
    private String installDir;
    private String type;
    private File baseDir;
    private boolean submodules;
    private MavenSession session;
    private String classifier;
    private Data[] dataSet;
    private boolean timestamped;
    private String openReplaceToken = "[[";
    private String closeReplaceToken = "]]";
    private Collection dataProducers = new ArrayList();

    public void setOpenReplaceToken(String openReplaceToken) {
        this.openReplaceToken = openReplaceToken;
        AbstractDescriptor.setOpenToken(openReplaceToken);
    }

    public void setCloseReplaceToken(String closeReplaceToken) {
        this.closeReplaceToken = closeReplaceToken;
        AbstractDescriptor.setCloseToken(closeReplaceToken);
    }

    protected void setData(Data[] pData) {
        this.dataSet = pData;
        this.dataProducers.clear();
        if (pData != null) {
            for (int i = 0; i < pData.length; ++i) {
                this.dataProducers.add(pData[i]);
            }
        }
    }

    protected VariableResolver initializeVariableResolver(Map variables) {
        variables.put("name", this.getProject().getName());
        variables.put("artifactId", this.getProject().getArtifactId());
        variables.put("groupId", this.getProject().getGroupId());
        variables.put("version", this.getProjectVersion());
        variables.put("description", this.getProject().getDescription());
        variables.put("extension", "deb");
        variables.put("baseDir", this.getProject().getBasedir().getAbsolutePath());
        variables.put("buildDir", this.buildDirectory.getAbsolutePath());
        variables.put("project.version", this.getProject().getVersion());
        variables.put("url", this.getProject().getUrl());
        return new MapVariableResolver(variables);
    }

    private String getProjectVersion() {
        String version = this.getProject().getVersion().replace('-', '+');
        if (this.timestamped && version.endsWith("+SNAPSHOT")) {
            version = version.substring(0, version.length() - "+SNAPSHOT".length());
            version = version + "~";
            version = version + new SimpleDateFormat("yyyyMMdd.HHmmss.SSS").format(new Date());
        }
        return version;
    }

    private boolean inExecRoot() {
        return this.session.getExecutionRootDirectory().equalsIgnoreCase(this.baseDir.toString());
    }

    public void execute() throws MojoExecutionException {
        this.setData(this.dataSet);
        if (!this.inExecRoot() && !this.submodules) {
            this.getLog().info((CharSequence)"skipping sub module: jdeb executing at top-level only");
            return;
        }
        try {
            VariableResolver resolver = this.initializeVariableResolver(new HashMap());
            File debFile = new File(Utils.replaceVariables(resolver, this.deb, this.openReplaceToken, this.closeReplaceToken));
            File controlDirFile = new File(Utils.replaceVariables(resolver, this.controlDir, this.openReplaceToken, this.closeReplaceToken));
            final File installDirFile = new File(Utils.replaceVariables(resolver, this.installDir, this.openReplaceToken, this.closeReplaceToken));
            File changesInFile = new File(Utils.replaceVariables(resolver, this.changesIn, this.openReplaceToken, this.closeReplaceToken));
            File changesOutFile = new File(Utils.replaceVariables(resolver, this.changesOut, this.openReplaceToken, this.closeReplaceToken));
            File changesSaveFile = new File(Utils.replaceVariables(resolver, this.changesSave, this.openReplaceToken, this.closeReplaceToken));
            if (this.dataProducers.isEmpty()) {
                final File file = this.getProject().getArtifact().getFile();
                if (file == null) {
                    this.getLog().warn((CharSequence)"There is no artifact to include if you call jdeb directly. The jdeb plugin is run during the install phase anyway.");
                    throw new MojoExecutionException("No artifact to include into deb");
                }
                this.dataProducers.add(new DataProducer(){

                    @Override
                    public void produce(DataConsumer receiver) {
                        try {
                            receiver.onEachFile(new FileInputStream(file), new File(installDirFile, file.getName()).getAbsolutePath(), "", "root", 0, "root", 0, 33188, file.length());
                        }
                        catch (Exception e) {
                            DebMojo.this.getLog().error((Throwable)e);
                        }
                    }
                });
            }
            Console infoConsole = new Console(){

                @Override
                public void println(String s) {
                    DebMojo.this.getLog().info((CharSequence)s);
                }
            };
            try {
                DebMaker debMaker = new DebMaker(infoConsole, debFile, controlDirFile, this.dataProducers, resolver);
                if (changesInFile.exists() && changesInFile.canRead()) {
                    debMaker.setChangesIn(changesInFile);
                    debMaker.setChangesOut(changesOutFile);
                    debMaker.setChangesSave(changesSaveFile);
                }
                debMaker.setCompression(this.compression);
                debMaker.makeDeb();
                if ("true".equalsIgnoreCase(this.attach)) {
                    this.getLog().info((CharSequence)("Attaching created debian archive " + debFile));
                    this.projectHelper.attachArtifact(this.getProject(), this.type, this.classifier, debFile);
                }
            }
            catch (PackagingException e) {
                this.getLog().error((CharSequence)("Failed to create debian package " + debFile), (Throwable)e);
                throw new MojoExecutionException("Failed to create debian package " + debFile, (Exception)e);
            }
        }
        catch (ParseException e) {
            throw new MojoExecutionException("Failed parsing pattern", (Exception)e);
        }
    }
}

