/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdeb.maven;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.vafer.jdeb.DataConsumer;
import org.vafer.jdeb.DataProducer;
import org.vafer.jdeb.maven.Mapper;
import org.vafer.jdeb.producers.DataProducerArchive;
import org.vafer.jdeb.producers.DataProducerDirectory;
import org.vafer.jdeb.producers.DataProducerFile;

public final class Data
implements DataProducer {
    private File src;
    private String type;
    private String[] includePatterns;
    private String[] excludePatterns;
    private Mapper mapper;

    public void setSrc(File src) {
        this.src = src;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setIncludes(String includes) {
        this.includePatterns = this.splitPatterns(includes);
    }

    public void setExcludes(String excludes) {
        this.excludePatterns = this.splitPatterns(excludes);
    }

    public String[] splitPatterns(String patterns) {
        String[] result = null;
        if (patterns != null && patterns.length() > 0) {
            ArrayList<String> tokens = new ArrayList<String>();
            StringTokenizer tok = new StringTokenizer(patterns, ", ", false);
            while (tok.hasMoreTokens()) {
                tokens.add(tok.nextToken());
            }
            result = tokens.toArray(new String[tokens.size()]);
        }
        return result;
    }

    @Override
    public void produce(DataConsumer pReceiver) throws IOException {
        if (!this.src.exists()) {
            throw new FileNotFoundException("Data source not found : " + this.src);
        }
        org.vafer.jdeb.mapping.Mapper[] mappers = null;
        if (this.mapper != null) {
            mappers = new org.vafer.jdeb.mapping.Mapper[]{this.mapper.createMapper()};
        }
        if ("file".equalsIgnoreCase(this.type)) {
            new DataProducerFile(this.src, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if ("archive".equalsIgnoreCase(this.type)) {
            new DataProducerArchive(this.src, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        if ("directory".equalsIgnoreCase(this.type)) {
            new DataProducerDirectory(this.src, this.includePatterns, this.excludePatterns, mappers).produce(pReceiver);
            return;
        }
        throw new IOException("Unknown type '" + this.type + "' (file|directory|archive) for " + this.src);
    }
}

