/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.threadgroup;

import org.tinygroup.logger.LogLevel;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;
import org.tinygroup.threadgroup.ExceptionCallBack;
import org.tinygroup.threadgroup.MultiThreadProcessor;
import org.tinygroup.threadgroup.Processor;

public abstract class AbstractProcessor
implements Processor {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessor.class);
    private String name;
    private MultiThreadProcessor multiThreadProcess;
    private ExceptionCallBack exceptionCallBack = null;

    public AbstractProcessor(String name) {
        this.name = name;
    }

    protected abstract void action() throws Exception;

    @Override
    public void setExceptionCallBack(ExceptionCallBack exceptionCallBack) {
        this.exceptionCallBack = exceptionCallBack;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void run() {
        try {
            LOGGER.logMessage(LogLevel.DEBUG, "\u7ebf\u7a0b<{}-{}>\u8fd0\u884c\u5f00\u59cb...", new Object[]{this.multiThreadProcess.getName(), this.name});
            this.action();
            LOGGER.logMessage(LogLevel.DEBUG, "\u7ebf\u7a0b<{}-{}>\u8fd0\u884c\u7ed3\u675f", new Object[]{this.multiThreadProcess.getName(), this.name});
        }
        catch (Exception e) {
            LOGGER.errorMessage(e.getMessage(), (Throwable)e, new Object[0]);
            if (this.exceptionCallBack != null) {
                this.exceptionCallBack.callBack(this, e);
            }
        }
        finally {
            this.multiThreadProcess.threadDone();
        }
    }

    @Override
    public void setMultiThreadProcess(MultiThreadProcessor multiThreadProcess) {
        this.multiThreadProcess = multiThreadProcess;
    }
}

