/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinygroup.commons.io.StreamUtil;
import org.tinygroup.commons.tools.CollectionUtil;
import org.tinygroup.parser.Node;
import org.tinygroup.parser.filter.NameFilter;
import org.tinygroup.vfs.FileObject;
import org.tinygroup.xmlparser.node.XmlNode;
import org.tinygroup.xmlparser.parser.XmlStringParser;

public class ConfigurationXmlUtil {
    public static List<XmlNode> combineSubList(XmlNode applicationNode, XmlNode componentNode, String nodeName, String keyPropertyName) {
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        ArrayList<XmlNode> result = new ArrayList<XmlNode>();
        if (applicationNode == null && componentNode == null) {
            return result;
        }
        List<XmlNode> applicationNodeList = ConfigurationXmlUtil.getNodeList(applicationNode, nodeName);
        List<XmlNode> componentNodeList = ConfigurationXmlUtil.getNodeList(componentNode, nodeName);
        if (componentNodeList.isEmpty()) {
            result.addAll(applicationNodeList);
            return result;
        }
        if (applicationNodeList.isEmpty()) {
            result.addAll(componentNodeList);
            return result;
        }
        ConfigurationXmlUtil.combineSubList(keyPropertyName, result, applicationNodeList, componentNodeList);
        return result;
    }

    private static void checkNodeName(XmlNode applicationNode, XmlNode componentNode) {
        if (applicationNode == null || componentNode == null) {
            return;
        }
        String applicationNodeName = applicationNode.getNodeName();
        String componentNodeName = componentNode.getNodeName();
        if (applicationNodeName != null && componentNodeName != null && !applicationNodeName.equals(componentNodeName)) {
            throw new RuntimeException(applicationNodeName + "\u4e0e" + componentNodeName + "\u4e24\u4e2a\u8282\u70b9\u540d\u79f0\u4e0d\u4e00\u81f4\uff01");
        }
    }

    private static void combineSubList(String keyPropertyName, List<XmlNode> result, List<XmlNode> applicationNodeList, List<XmlNode> componentNodeList) {
        Map<String, XmlNode> appConfigMap = ConfigurationXmlUtil.nodeListToMap(applicationNodeList, keyPropertyName);
        Map<String, XmlNode> compConfigMap = ConfigurationXmlUtil.nodeListToMap(componentNodeList, keyPropertyName);
        for (String key : appConfigMap.keySet()) {
            XmlNode compNode = compConfigMap.get(key);
            XmlNode appNode = appConfigMap.get(key);
            if (compNode == null) {
                result.add(appNode);
                continue;
            }
            result.add(ConfigurationXmlUtil.combine(appNode, compNode));
        }
        for (String key : compConfigMap.keySet()) {
            XmlNode appNode = appConfigMap.get(key);
            if (appNode != null) continue;
            result.add(compConfigMap.get(key));
        }
    }

    private static Map<String, XmlNode> nodeListToMap(List<XmlNode> subNodes, String keyPropertyName) {
        HashMap<String, XmlNode> nodeMap = new HashMap<String, XmlNode>();
        for (XmlNode node : subNodes) {
            String value = node.getAttribute(keyPropertyName);
            nodeMap.put(value, node);
        }
        return nodeMap;
    }

    private static List<XmlNode> getNodeList(XmlNode node, String nodeName) {
        List<Object> nodeList = new ArrayList<XmlNode>();
        if (node != null) {
            nodeList = node.getSubNodes(nodeName);
        }
        return nodeList;
    }

    public static XmlNode combineXmlNode(XmlNode applicationNode, XmlNode componentNode) {
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        if (applicationNode == null && componentNode == null) {
            return null;
        }
        XmlNode result = null;
        result = applicationNode != null && componentNode == null ? applicationNode : (applicationNode == null && componentNode != null ? componentNode : ConfigurationXmlUtil.combine(applicationNode, componentNode));
        return result;
    }

    private static XmlNode combine(XmlNode appNode, XmlNode compNode) {
        XmlNode result = new XmlNode(appNode.getNodeName());
        result.setAttribute(compNode.getAttributes());
        result.setAttribute(appNode.getAttributes());
        if (!CollectionUtil.isEmpty((Collection)compNode.getSubNodes())) {
            result.addAll(compNode.getSubNodes());
        }
        if (!CollectionUtil.isEmpty((Collection)appNode.getSubNodes())) {
            result.addAll(appNode.getSubNodes());
        }
        return result;
    }

    public static List<XmlNode> combineSubList(XmlNode applicationNode, XmlNode componentNode) {
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        ArrayList<XmlNode> result = new ArrayList<XmlNode>();
        if (applicationNode == null && componentNode == null) {
            return result;
        }
        if (componentNode != null && componentNode.getSubNodes() != null) {
            result.addAll(componentNode.getSubNodes());
        }
        if (applicationNode != null && applicationNode.getSubNodes() != null) {
            result.addAll(applicationNode.getSubNodes());
        }
        return result;
    }

    public static List<XmlNode> combineSubList(String nodeName, XmlNode applicationNode, XmlNode componentNode) {
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        ArrayList<XmlNode> result = new ArrayList<XmlNode>();
        if (applicationNode == null && componentNode == null) {
            return result;
        }
        if (componentNode != null && componentNode.getSubNodes(nodeName) != null) {
            result.addAll(componentNode.getSubNodes(nodeName));
        }
        if (applicationNode != null && applicationNode.getSubNodes(nodeName) != null) {
            result.addAll(applicationNode.getSubNodes(nodeName));
        }
        return result;
    }

    public static List<XmlNode> combineFindNodeList(String nodeName, XmlNode applicationNode, XmlNode componentNode) {
        NameFilter nameFilter;
        List nodes;
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        ArrayList<XmlNode> result = new ArrayList<XmlNode>();
        if (applicationNode == null && componentNode == null) {
            return result;
        }
        if (componentNode != null && (nodes = (nameFilter = new NameFilter((Node)componentNode)).findNodeList(nodeName)) != null) {
            result.addAll(nodes);
        }
        if (applicationNode != null && (nodes = (nameFilter = new NameFilter((Node)applicationNode)).findNodeList(nodeName)) != null) {
            result.addAll(nodes);
        }
        return result;
    }

    public static XmlNode parseXmlFromFileObject(FileObject fileObject) throws IOException {
        String config = StreamUtil.readText((InputStream)fileObject.getInputStream(), (String)"UTF-8", (boolean)true);
        return (XmlNode)new XmlStringParser().parse(config).getRoot();
    }

    public static String getPropertyName(XmlNode applicationNode, XmlNode componentNode, String attributeName) {
        String value = null;
        ConfigurationXmlUtil.checkNodeName(applicationNode, componentNode);
        if (applicationNode != null) {
            value = applicationNode.getAttribute(attributeName);
        }
        if (value == null && componentNode != null) {
            value = componentNode.getAttribute(attributeName);
        }
        return value;
    }

    public static String getPropertyName(XmlNode applicationNode, XmlNode componentNode, String attributeName, String defaultValue) {
        String value = ConfigurationXmlUtil.getPropertyName(applicationNode, componentNode, attributeName);
        if (value == null || value.trim().length() == 0) {
            value = defaultValue;
        }
        return value;
    }
}

