/*
 * Decompiled with CFR 0.152.
 */
package org.tinygroup.config.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tinygroup.commons.tools.StringUtil;
import org.tinygroup.commons.tools.VariableUtil;
import org.tinygroup.config.ConfigurationManager;
import org.tinygroup.config.impl.ConfigurationManagerImpl;
import org.tinygroup.config.util.ConfigurationXmlUtil;
import org.tinygroup.logger.Logger;
import org.tinygroup.logger.LoggerFactory;

public final class ConfigurationUtil
extends ConfigurationXmlUtil {
    private static ConfigurationManager configurationManager = new ConfigurationManagerImpl();
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigurationUtil.class);

    private ConfigurationUtil() {
    }

    public static ConfigurationManager getConfigurationManager() {
        return configurationManager;
    }

    public static void clear() {
        configurationManager.clear();
    }

    @Deprecated
    public static String replace(String content, String name, String value) {
        Pattern pattern = Pattern.compile("[{]" + name + "[}]");
        Matcher matcher = pattern.matcher(content);
        StringBuilder buf = new StringBuilder();
        int curpos = 0;
        while (matcher.find()) {
            buf.append(content.substring(curpos, matcher.start()));
            curpos = matcher.end();
            buf.append(value);
        }
        buf.append(content.substring(curpos));
        return buf.toString();
    }

    public static void replace(Map<String, String> proMap, Map<String, String> proMap2) {
        for (String key : proMap.keySet()) {
            proMap.put(key, ConfigurationUtil.replace(proMap.get(key), proMap2));
        }
        for (String key : proMap2.keySet()) {
            proMap2.put(key, ConfigurationUtil.replace(proMap2.get(key), proMap));
        }
    }

    public static Map<String, String> replace(Map<String, String> proMap) {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        for (String key : proMap.keySet()) {
            tempMap.put(key, ConfigurationUtil.replace(proMap.get(key), proMap));
        }
        return tempMap;
    }

    public static String replace(String value, Map<String, String> proMap) {
        Pattern pattern = Pattern.compile("(\\{[^\\}]*\\})");
        Matcher matcher = pattern.matcher(value);
        int curpos = 0;
        StringBuilder buf = new StringBuilder();
        while (matcher.find()) {
            buf.append(value.substring(curpos, matcher.start()));
            curpos = matcher.end();
            String var = value.substring(matcher.start(), curpos);
            String key = StringUtil.substring((String)var, (int)1, (int)(var.length() - 1));
            if (proMap.containsKey(key)) {
                buf.append(proMap.get(key));
                continue;
            }
            if (!StringUtil.isBlank((String)key) && key.startsWith("TINY_ENV_")) {
                String envKey = key.substring("TINY_ENV_".length());
                if (!VariableUtil.hasEnvVariable((String)envKey)) {
                    throw new RuntimeException("not found environment variables,key:" + envKey);
                }
                buf.append(VariableUtil.getEnvVariable((String)envKey));
                continue;
            }
            LOGGER.warnMessage("not found var:{}", new Object[]{var});
            buf.append(var);
        }
        buf.append(value.substring(curpos));
        return buf.toString();
    }
}

