/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.handler;

import java.util.Map;
import org.springframework.context.support.ApplicationObjectSupport;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.reactive.CorsConfigurationSource;
import org.springframework.web.cors.reactive.CorsProcessor;
import org.springframework.web.cors.reactive.CorsUtils;
import org.springframework.web.cors.reactive.DefaultCorsProcessor;
import org.springframework.web.cors.reactive.UrlBasedCorsConfigurationSource;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebHandler;
import org.springframework.web.util.pattern.PathPatternParser;
import reactor.core.publisher.Mono;

public abstract class AbstractHandlerMapping
extends ApplicationObjectSupport
implements HandlerMapping,
Ordered {
    private static final WebHandler REQUEST_HANDLED_HANDLER = exchange -> Mono.empty();
    private final PathPatternParser patternParser;
    private final UrlBasedCorsConfigurationSource globalCorsConfigSource;
    private CorsProcessor corsProcessor = new DefaultCorsProcessor();
    private int order = Integer.MAX_VALUE;

    public AbstractHandlerMapping() {
        this.patternParser = new PathPatternParser();
        this.globalCorsConfigSource = new UrlBasedCorsConfigurationSource(this.patternParser);
    }

    public void setUseCaseSensitiveMatch(boolean caseSensitiveMatch) {
        this.patternParser.setCaseSensitive(caseSensitiveMatch);
    }

    public void setUseTrailingSlashMatch(boolean trailingSlashMatch) {
        this.patternParser.setMatchOptionalTrailingSeparator(trailingSlashMatch);
    }

    public PathPatternParser getPathPatternParser() {
        return this.patternParser;
    }

    public void setCorsConfigurations(Map<String, CorsConfiguration> corsConfigurations) {
        this.globalCorsConfigSource.setCorsConfigurations(corsConfigurations);
    }

    public void setCorsProcessor(CorsProcessor corsProcessor) {
        Assert.notNull((Object)corsProcessor, (String)"CorsProcessor must not be null");
        this.corsProcessor = corsProcessor;
    }

    public CorsProcessor getCorsProcessor() {
        return this.corsProcessor;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public Mono<Object> getHandler(ServerWebExchange exchange) {
        return this.getHandlerInternal(exchange).map(handler -> {
            if (CorsUtils.isCorsRequest((ServerHttpRequest)exchange.getRequest())) {
                CorsConfiguration config;
                CorsConfiguration configA = this.globalCorsConfigSource.getCorsConfiguration(exchange);
                CorsConfiguration configB = this.getCorsConfiguration(handler, exchange);
                CorsConfiguration corsConfiguration = config = configA != null ? configA.combine(configB) : configB;
                if (!this.getCorsProcessor().process(config, exchange) || CorsUtils.isPreFlightRequest((ServerHttpRequest)exchange.getRequest())) {
                    return REQUEST_HANDLED_HANDLER;
                }
            }
            return handler;
        });
    }

    protected abstract Mono<?> getHandlerInternal(ServerWebExchange var1);

    @Nullable
    protected CorsConfiguration getCorsConfiguration(Object handler, ServerWebExchange exchange) {
        if (handler instanceof CorsConfigurationSource) {
            return ((CorsConfigurationSource)handler).getCorsConfiguration(exchange);
        }
        return null;
    }
}

