/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.accept;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.web.reactive.accept.FixedContentTypeResolver;
import org.springframework.web.reactive.accept.HeaderContentTypeResolver;
import org.springframework.web.reactive.accept.ParameterContentTypeResolver;
import org.springframework.web.reactive.accept.RequestedContentTypeResolver;

public class RequestedContentTypeResolverBuilder {
    private final List<Supplier<RequestedContentTypeResolver>> candidates = new ArrayList<Supplier<RequestedContentTypeResolver>>();

    public ParameterResolverConfigurer parameterResolver() {
        ParameterResolverConfigurer parameterBuilder = new ParameterResolverConfigurer();
        this.candidates.add(() -> parameterBuilder.createResolver());
        return parameterBuilder;
    }

    public void headerResolver() {
        this.candidates.add(HeaderContentTypeResolver::new);
    }

    public void fixedResolver(MediaType ... mediaTypes) {
        this.candidates.add(() -> new FixedContentTypeResolver(Arrays.asList(mediaTypes)));
    }

    public void resolver(RequestedContentTypeResolver resolver) {
        this.candidates.add(() -> resolver);
    }

    public RequestedContentTypeResolver build() {
        List<HeaderContentTypeResolver> resolvers = this.candidates.isEmpty() ? Collections.singletonList(new HeaderContentTypeResolver()) : this.candidates.stream().map(Supplier::get).collect(Collectors.toList());
        return exchange -> {
            for (RequestedContentTypeResolver resolver : resolvers) {
                List<MediaType> mediaTypes = resolver.resolveMediaTypes(exchange);
                if (mediaTypes.equals(RequestedContentTypeResolver.MEDIA_TYPE_ALL_LIST)) continue;
                return mediaTypes;
            }
            return RequestedContentTypeResolver.MEDIA_TYPE_ALL_LIST;
        };
    }

    public static class ParameterResolverConfigurer {
        private final Map<String, MediaType> mediaTypes = new HashMap<String, MediaType>();
        @Nullable
        private String parameterName;

        public ParameterResolverConfigurer mediaType(String key, MediaType mediaType) {
            this.mediaTypes.put(key, mediaType);
            return this;
        }

        public ParameterResolverConfigurer mediaType(Map<String, MediaType> mediaTypes) {
            this.mediaTypes.putAll(mediaTypes);
            return this;
        }

        public ParameterResolverConfigurer parameterName(String parameterName) {
            this.parameterName = parameterName;
            return this;
        }

        private RequestedContentTypeResolver createResolver() {
            ParameterContentTypeResolver resolver = new ParameterContentTypeResolver(this.mediaTypes);
            if (this.parameterName != null) {
                resolver.setParameterName(this.parameterName);
            }
            return resolver;
        }
    }
}

