/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.reactive.socket.server.upgrade;

import java.io.IOException;
import java.security.Principal;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.server.WebSocketServerFactory;
import org.springframework.context.Lifecycle;
import org.springframework.core.NamedThreadLocal;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.server.reactive.AbstractServerHttpRequest;
import org.springframework.http.server.reactive.AbstractServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.reactive.socket.HandshakeInfo;
import org.springframework.web.reactive.socket.WebSocketHandler;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketHandlerAdapter;
import org.springframework.web.reactive.socket.adapter.JettyWebSocketSession;
import org.springframework.web.reactive.socket.server.RequestUpgradeStrategy;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JettyRequestUpgradeStrategy
implements RequestUpgradeStrategy,
Lifecycle {
    private static final ThreadLocal<WebSocketHandlerContainer> adapterHolder = new NamedThreadLocal("JettyWebSocketHandlerAdapter");
    @Nullable
    private WebSocketServerFactory factory;
    @Nullable
    private volatile ServletContext servletContext;
    private volatile boolean running = false;
    private final Object lifecycleMonitor = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            ServletContext servletContext = this.servletContext;
            if (!this.isRunning() && servletContext != null) {
                this.running = true;
                try {
                    this.factory = new WebSocketServerFactory(servletContext);
                    this.factory.setCreator((request, response) -> {
                        WebSocketHandlerContainer container = adapterHolder.get();
                        String protocol = container.getProtocol();
                        if (protocol != null) {
                            response.setAcceptedSubProtocol(protocol);
                        }
                        return container.getAdapter();
                    });
                    this.factory.start();
                }
                catch (Throwable ex) {
                    throw new IllegalStateException("Unable to start WebSocketServerFactory", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.isRunning()) {
                this.running = false;
                if (this.factory != null) {
                    try {
                        this.factory.stop();
                    }
                    catch (Throwable ex) {
                        throw new IllegalStateException("Failed to stop WebSocketServerFactory", ex);
                    }
                }
            }
        }
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Mono<Void> upgrade(ServerWebExchange exchange, WebSocketHandler handler, @Nullable String subProtocol) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpResponse response = exchange.getResponse();
        HttpServletRequest servletRequest = this.getHttpServletRequest(request);
        HttpServletResponse servletResponse = this.getHttpServletResponse(response);
        JettyWebSocketHandlerAdapter adapter = new JettyWebSocketHandlerAdapter(handler, session -> {
            HandshakeInfo info = this.getHandshakeInfo(exchange, subProtocol);
            DataBufferFactory factory = response.bufferFactory();
            return new JettyWebSocketSession((Session)session, info, factory);
        });
        this.startLazily(servletRequest);
        Assert.state((this.factory != null ? 1 : 0) != 0, (String)"No WebSocketServerFactory available");
        boolean isUpgrade = this.factory.isUpgradeRequest(servletRequest, servletResponse);
        Assert.isTrue((boolean)isUpgrade, (String)"Not a WebSocket handshake");
        try {
            adapterHolder.set(new WebSocketHandlerContainer(adapter, subProtocol));
            this.factory.acceptWebSocket(servletRequest, servletResponse);
        }
        catch (IOException ex) {
            Mono mono = Mono.error((Throwable)ex);
            return mono;
        }
        finally {
            adapterHolder.remove();
        }
        return Mono.empty();
    }

    private HttpServletRequest getHttpServletRequest(ServerHttpRequest request) {
        Assert.isInstanceOf(AbstractServerHttpRequest.class, (Object)request, (String)"ServletServerHttpRequest required");
        return (HttpServletRequest)((AbstractServerHttpRequest)request).getNativeRequest();
    }

    private HttpServletResponse getHttpServletResponse(ServerHttpResponse response) {
        Assert.isInstanceOf(AbstractServerHttpResponse.class, (Object)response, (String)"ServletServerHttpResponse required");
        return (HttpServletResponse)((AbstractServerHttpResponse)response).getNativeResponse();
    }

    private HandshakeInfo getHandshakeInfo(ServerWebExchange exchange, @Nullable String protocol) {
        ServerHttpRequest request = exchange.getRequest();
        Mono principal = exchange.getPrincipal();
        return new HandshakeInfo(request.getURI(), request.getHeaders(), (Mono<Principal>)principal, protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startLazily(HttpServletRequest request) {
        if (this.servletContext != null) {
            return;
        }
        Object object = this.lifecycleMonitor;
        synchronized (object) {
            if (this.servletContext == null) {
                this.servletContext = request.getServletContext();
                this.start();
            }
        }
    }

    private static class WebSocketHandlerContainer {
        private final JettyWebSocketHandlerAdapter adapter;
        @Nullable
        private final String protocol;

        public WebSocketHandlerContainer(JettyWebSocketHandlerAdapter adapter, @Nullable String protocol) {
            this.adapter = adapter;
            this.protocol = protocol;
        }

        public JettyWebSocketHandlerAdapter getAdapter() {
            return this.adapter;
        }

        @Nullable
        public String getProtocol() {
            return this.protocol;
        }
    }
}

