/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.AbstractController;
import org.springframework.web.servlet.view.RedirectView;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.FlowRequestHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.ResponseInstructionHandler;

public class FlowController
extends AbstractController
implements InitializingBean {
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();

    public FlowController() {
        this.setCacheSeconds(0);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentHandler.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentHandler, (String)"The argument handler property is required");
    }

    protected ModelAndView handleRequestInternal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        ServletExternalContext context = new ServletExternalContext(this.getServletContext(), request, response);
        ResponseInstruction responseInstruction = this.createRequestHandler().handleFlowRequest(context);
        return this.toModelAndView(responseInstruction, context);
    }

    protected FlowRequestHandler createRequestHandler() {
        return new FlowRequestHandler(this.getFlowExecutor(), this.getArgumentHandler());
    }

    protected ModelAndView toModelAndView(final ResponseInstruction responseInstruction, final ExternalContext context) {
        return (ModelAndView)new ResponseInstructionHandler(){

            protected void handleApplicationView(ApplicationView view) throws Exception {
                HashMap model = new HashMap(view.getModel());
                FlowController.this.argumentHandler.exposeFlowExecutionContext(responseInstruction.getFlowExecutionKey(), responseInstruction.getFlowExecutionContext(), model);
                this.setResult(new ModelAndView(view.getViewName(), model));
            }

            protected void handleFlowDefinitionRedirect(FlowDefinitionRedirect redirect) throws Exception {
                String flowUrl = FlowController.this.argumentHandler.createFlowDefinitionUrl(redirect, context);
                this.setResult(new ModelAndView((View)new RedirectView(flowUrl)));
            }

            protected void handleFlowExecutionRedirect(FlowExecutionRedirect redirect) throws Exception {
                String flowExecutionUrl = FlowController.this.argumentHandler.createFlowExecutionUrl(responseInstruction.getFlowExecutionKey(), responseInstruction.getFlowExecutionContext(), context);
                this.setResult(new ModelAndView((View)new RedirectView(flowExecutionUrl)));
            }

            protected void handleExternalRedirect(ExternalRedirect redirect) throws Exception {
                String externalUrl = FlowController.this.argumentHandler.createExternalUrl(redirect, responseInstruction.getFlowExecutionKey(), context);
                this.setResult(new ModelAndView((View)new RedirectView(externalUrl)));
            }

            protected void handleNull() throws Exception {
                this.setResult(null);
            }
        }.handleQuietly(responseInstruction).getResult();
    }
}

