/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolder;
import org.springframework.webflow.executor.jsf.FlowExecutionHolderUtils;

public class FlowSystemCleanupFilter
extends OncePerRequestFilter {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws ServletException, IOException {
        try {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        finally {
            this.cleanupCurrentFlowExecution((ServletRequest)request);
            ExternalContextHolder.setExternalContext(null);
        }
    }

    private void cleanupCurrentFlowExecution(ServletRequest request) {
        if (this.isFlowExecutionRestored(request)) {
            this.getFlowExecutionHolder(request).unlockFlowExecutionIfNecessary();
            request.removeAttribute(FlowExecutionHolderUtils.getFlowExecutionHolderKey());
        }
    }

    private boolean isFlowExecutionRestored(ServletRequest request) {
        return this.getFlowExecutionHolder(request) != null;
    }

    private FlowExecutionHolder getFlowExecutionHolder(ServletRequest request) {
        return (FlowExecutionHolder)request.getAttribute(FlowExecutionHolderUtils.getFlowExecutionHolderKey());
    }
}

