/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine;

import java.io.Serializable;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.engine.AnnotatedObject;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public abstract class FlowVariable
extends AnnotatedObject
implements Serializable {
    private String name;
    private ScopeType scope;

    public FlowVariable(String name, ScopeType scope) {
        Assert.hasText((String)name, (String)"The variable name is required");
        Assert.notNull((Object)((Object)scope), (String)"The variable scope type is required");
        this.name = name;
        this.scope = scope;
    }

    public String getName() {
        return this.name;
    }

    public ScopeType getScope() {
        return this.scope;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowVariable)) {
            return false;
        }
        FlowVariable other = (FlowVariable)o;
        return this.name.equals(other.name) && this.scope.equals((Object)other.scope);
    }

    public int hashCode() {
        return this.name.hashCode() + this.scope.hashCode();
    }

    public final void create(RequestContext context) {
        this.scope.getScope(context).put(this.name, this.createVariableValue(context));
    }

    protected abstract Object createVariableValue(RequestContext var1);

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("scope", (Object)this.scope).toString();
    }
}

