/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.binding.expression.EvaluationContext;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.util.Assert;
import org.springframework.webflow.action.AbstractAction;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ScopeType;

public class SetAction
extends AbstractAction {
    private SettableExpression attributeExpression;
    private ScopeType scope;
    private Expression valueExpression;

    public SetAction(SettableExpression attributeExpression, ScopeType scope, Expression valueExpression) {
        Assert.notNull((Object)attributeExpression, (String)"The attribute expression is required");
        Assert.notNull((Object)((Object)scope), (String)"The scope type is required");
        Assert.notNull((Object)valueExpression, (String)"The value expression is required");
        this.attributeExpression = attributeExpression;
        this.scope = scope;
        this.valueExpression = valueExpression;
    }

    protected Event doExecute(RequestContext context) throws Exception {
        EvaluationContext evaluationContext = this.getEvaluationContext(context);
        Object value = this.valueExpression.evaluate((Object)context, evaluationContext);
        MutableAttributeMap scopeMap = this.scope.getScope(context);
        this.attributeExpression.evaluateToSet((Object)scopeMap, value, evaluationContext);
        return this.success();
    }

    protected EvaluationContext getEvaluationContext(RequestContext context) {
        return null;
    }
}

