/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.action;

import org.springframework.core.JdkVersion;
import org.springframework.core.enums.LabeledEnum;
import org.springframework.webflow.action.ResultEventFactory;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.support.EventFactorySupport;

public class ResultObjectBasedEventFactory
extends EventFactorySupport
implements ResultEventFactory {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$org$springframework$core$enums$LabeledEnum;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$springframework$webflow$execution$Event;

    public Event createResultEvent(Object source, Object resultObject, RequestContext context) {
        if (resultObject == null) {
            return this.event(source, this.getNullEventId());
        }
        if (this.isBoolean(resultObject.getClass())) {
            return this.event(source, (Boolean)resultObject);
        }
        if (this.isLabeledEnum(resultObject.getClass())) {
            String resultId = ((LabeledEnum)resultObject).getLabel();
            return this.event(source, resultId, this.getResultAttributeName(), resultObject);
        }
        if (this.isJdk5Enum(resultObject.getClass())) {
            String eventId = EnumNameResolver.getEnumName(resultObject);
            return this.event(source, eventId, this.getResultAttributeName(), resultObject);
        }
        if (this.isString(resultObject.getClass())) {
            return this.event(source, (String)resultObject);
        }
        if (this.isEvent(resultObject.getClass())) {
            return (Event)resultObject;
        }
        throw new IllegalArgumentException("Cannot deal with result object '" + resultObject + "' of type '" + resultObject.getClass() + "'");
    }

    public boolean isMappedValueType(Class type) {
        return this.isBoolean(type) || this.isLabeledEnum(type) || this.isJdk5Enum(type) || this.isString(type) || this.isEvent(type);
    }

    private boolean isBoolean(Class type) {
        return (class$java$lang$Boolean == null ? (class$java$lang$Boolean = ResultObjectBasedEventFactory.class$("java.lang.Boolean")) : class$java$lang$Boolean).equals(type) || Boolean.TYPE.equals(type);
    }

    private boolean isLabeledEnum(Class type) {
        return (class$org$springframework$core$enums$LabeledEnum == null ? (class$org$springframework$core$enums$LabeledEnum = ResultObjectBasedEventFactory.class$("org.springframework.core.enums.LabeledEnum")) : class$org$springframework$core$enums$LabeledEnum).isAssignableFrom(type);
    }

    private boolean isJdk5Enum(Class type) {
        if (JdkVersion.getMajorJavaVersion() >= 2) {
            return type.isEnum();
        }
        return false;
    }

    private boolean isString(Class type) {
        return (class$java$lang$String == null ? (class$java$lang$String = ResultObjectBasedEventFactory.class$("java.lang.String")) : class$java$lang$String).equals(type);
    }

    private boolean isEvent(Class type) {
        return (class$org$springframework$webflow$execution$Event == null ? (class$org$springframework$webflow$execution$Event = ResultObjectBasedEventFactory.class$("org.springframework.webflow.execution.Event")) : class$org$springframework$webflow$execution$Event).isAssignableFrom(type);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class EnumNameResolver {
        private EnumNameResolver() {
        }

        public static String getEnumName(Object enumValue) {
            return ((Enum)enumValue).name();
        }
    }
}

