/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api.impl;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.map.DeserializationContext;
import org.codehaus.jackson.map.JsonDeserializer;
import org.springframework.social.twitter.api.Trend;
import org.springframework.social.twitter.api.Trends;
import org.springframework.social.twitter.api.impl.LocalTrendsHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class LocalTrendsDeserializer
extends JsonDeserializer<LocalTrendsHolder> {
    private static final String LOCAL_TREND_DATE_FORMAT = "yyyy-mm-dd'T'HH:mm:ss'Z'";

    LocalTrendsDeserializer() {
    }

    public LocalTrendsHolder deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode tree = jp.readValueAsTree();
        Iterator dayIt = tree.iterator();
        if (dayIt.hasNext()) {
            JsonNode day = (JsonNode)dayIt.next();
            Date createdAt = LocalTrendsDeserializer.toDate(day.get("created_at").asText());
            JsonNode trendNodes = day.get("trends");
            ArrayList<Trend> trends = new ArrayList<Trend>();
            for (JsonNode trendNode : trendNodes) {
                trends.add(new Trend(trendNode.get("name").asText(), trendNode.get("query").getTextValue()));
            }
            jp.skipChildren();
            return new LocalTrendsHolder(new Trends(createdAt, trends));
        }
        throw ctxt.mappingException(LocalTrendsHolder.class);
    }

    private static Date toDate(String dateString) {
        try {
            return new SimpleDateFormat(LOCAL_TREND_DATE_FORMAT).parse(dateString);
        }
        catch (ParseException e) {
            return null;
        }
    }
}

