/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.twitter.api;

import java.io.Serializable;
import java.util.Arrays;

public class MediaEntity
implements Serializable {
    private static final long serialVersionUID = 1L;
    private long id;
    private String mediaHttp;
    private String mediaHttps;
    private String url;
    private String display;
    private String expanded;
    private String type;
    private int[] indices;

    public MediaEntity(long id, String mediaHttp, String mediaHttps, String url, String display, String expanded, String type, int[] indices) {
        this.id = id;
        this.mediaHttp = mediaHttp;
        this.mediaHttps = mediaHttps;
        this.url = url;
        this.display = display;
        this.expanded = expanded;
        this.type = type;
        this.indices = indices;
    }

    public long getId() {
        return this.id;
    }

    public String getMediaUrl() {
        return this.mediaHttp;
    }

    public String getMediaSecureUrl() {
        return this.mediaHttps;
    }

    public String getType() {
        return this.type;
    }

    public String getDisplayUrl() {
        return this.display;
    }

    public String getExpandedUrl() {
        return this.expanded;
    }

    public String getUrl() {
        return this.url;
    }

    public int[] getIndices() {
        if (this.indices == null || this.indices.length <= 0) {
            return new int[0];
        }
        return this.indices;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaEntity that = (MediaEntity)o;
        if (this.id != that.id) {
            return false;
        }
        if (this.display != null ? !this.display.equals(that.display) : that.display != null) {
            return false;
        }
        if (this.expanded != null ? !this.expanded.equals(that.expanded) : that.expanded != null) {
            return false;
        }
        if (!Arrays.equals(this.indices, that.indices)) {
            return false;
        }
        if (this.mediaHttp != null ? !this.mediaHttp.equals(that.mediaHttp) : that.mediaHttp != null) {
            return false;
        }
        if (this.mediaHttps != null ? !this.mediaHttps.equals(that.mediaHttps) : that.mediaHttps != null) {
            return false;
        }
        if (this.type != null ? !this.type.equals(that.type) : that.type != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(that.url) : that.url != null);
    }

    public int hashCode() {
        int result = (int)(this.id ^ this.id >>> 32);
        result = 31 * result + (this.mediaHttp != null ? this.mediaHttp.hashCode() : 0);
        result = 31 * result + (this.mediaHttps != null ? this.mediaHttps.hashCode() : 0);
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        result = 31 * result + (this.display != null ? this.display.hashCode() : 0);
        result = 31 * result + (this.expanded != null ? this.expanded.hashCode() : 0);
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.indices != null ? Arrays.hashCode(this.indices) : 0);
        return result;
    }
}

