/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.google.api.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;

public abstract class ApiEnumDeserializer<T extends Enum<?>>
extends JsonDeserializer<T> {
    private final Class<T> type;

    public ApiEnumDeserializer(Class<T> type) {
        this.type = type;
    }

    public T deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        String camelCase = jp.getText();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelCase.length(); ++i) {
            char c = camelCase.charAt(i);
            if (Character.isUpperCase(c)) {
                sb.append('_').append(c);
                continue;
            }
            sb.append(Character.toUpperCase(c));
        }
        T value = Enum.valueOf(this.type, sb.toString());
        return value;
    }
}

