/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire;

import com.gemstone.gemfire.cache.query.SelectResults;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.gemfire.GemfireOperations;
import org.springframework.session.ExpiringSession;
import org.springframework.session.data.gemfire.AbstractGemFireOperationsSessionRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemFireOperationsSessionRepository
extends AbstractGemFireOperationsSessionRepository {
    protected static final String FIND_SESSIONS_BY_INDEX_NAME_VALUE_QUERY = "SELECT s FROM %1$s s WHERE s.attributes['%2$s'] = $1";
    protected static final String FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY = "SELECT s FROM %1$s s WHERE s.principalName = $1";

    public GemFireOperationsSessionRepository(GemfireOperations template) {
        super(template);
    }

    @Override
    public Map<String, ExpiringSession> findByIndexNameAndIndexValue(String indexName, String indexValue) {
        SelectResults results = this.getTemplate().find(this.prepareQuery(indexName), new Object[]{indexValue});
        HashMap<String, ExpiringSession> sessions = new HashMap<String, ExpiringSession>(results.size());
        for (ExpiringSession session : results.asList()) {
            sessions.put(session.getId(), session);
        }
        return sessions;
    }

    protected String prepareQuery(String indexName) {
        return PRINCIPAL_NAME_INDEX_NAME.equals(indexName) ? String.format(FIND_SESSIONS_BY_PRINCIPAL_NAME_QUERY, this.getFullyQualifiedRegionName()) : String.format(FIND_SESSIONS_BY_INDEX_NAME_VALUE_QUERY, this.getFullyQualifiedRegionName(), indexName);
    }

    @Override
    public ExpiringSession createSession() {
        return AbstractGemFireOperationsSessionRepository.GemFireSession.create(this.getMaxInactiveIntervalInSeconds());
    }

    @Override
    public ExpiringSession getSession(String sessionId) {
        ExpiringSession storedSession = (ExpiringSession)this.getTemplate().get((Object)sessionId);
        if (storedSession != null) {
            if (storedSession.isExpired()) {
                this.delete(storedSession.getId());
            } else {
                return AbstractGemFireOperationsSessionRepository.GemFireSession.from(storedSession);
            }
        }
        return null;
    }

    @Override
    public void save(ExpiringSession session) {
        this.getTemplate().put((Object)session.getId(), (Object)new AbstractGemFireOperationsSessionRepository.GemFireSession(session));
    }

    @Override
    public void delete(String sessionId) {
        this.handleDeleted(sessionId, (ExpiringSession)this.getTemplate().remove((Object)sessionId));
    }
}

