/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.gemfire.config.annotation.web.http.support;

import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.InterestResultPolicy;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.RegionShortcut;
import com.gemstone.gemfire.cache.client.ClientRegionShortcut;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.data.gemfire.GenericRegionFactoryBean;
import org.springframework.data.gemfire.client.ClientRegionFactoryBean;
import org.springframework.data.gemfire.client.Interest;
import org.springframework.session.data.gemfire.config.annotation.web.http.GemFireHttpSessionConfiguration;
import org.springframework.session.data.gemfire.support.GemFireUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GemFireCacheTypeAwareRegionFactoryBean<K, V>
implements FactoryBean<Region<K, V>>,
InitializingBean {
    protected static final ClientRegionShortcut DEFAULT_CLIENT_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_CLIENT_REGION_SHORTCUT;
    protected static final RegionShortcut DEFAULT_SERVER_REGION_SHORTCUT = GemFireHttpSessionConfiguration.DEFAULT_SERVER_REGION_SHORTCUT;
    protected static final String DEFAULT_SPRING_SESSION_GEMFIRE_REGION_NAME = "ClusteredSpringSessions";
    private ClientRegionShortcut clientRegionShortcut;
    private GemFireCache gemfireCache;
    private Region<K, V> region;
    private RegionAttributes<K, V> regionAttributes;
    private RegionShortcut serverRegionShortcut;
    private String regionName;

    public void afterPropertiesSet() throws Exception {
        GemFireCache gemfireCache = this.getGemfireCache();
        this.region = GemFireUtils.isClient(gemfireCache) ? this.newClientRegion(gemfireCache) : this.newServerRegion(gemfireCache);
    }

    protected Region<K, V> newServerRegion(GemFireCache gemfireCache) throws Exception {
        GenericRegionFactoryBean serverRegion = new GenericRegionFactoryBean();
        serverRegion.setCache(gemfireCache);
        serverRegion.setAttributes(this.getRegionAttributes());
        serverRegion.setRegionName(this.getRegionName());
        serverRegion.setShortcut(this.getServerRegionShortcut());
        serverRegion.afterPropertiesSet();
        return serverRegion.getObject();
    }

    protected Region<K, V> newClientRegion(GemFireCache gemfireCache) throws Exception {
        ClientRegionFactoryBean clientRegion = new ClientRegionFactoryBean();
        ClientRegionShortcut shortcut = this.getClientRegionShortcut();
        clientRegion.setCache(gemfireCache);
        clientRegion.setAttributes(this.getRegionAttributes());
        clientRegion.setInterests(this.registerInterests(!GemFireUtils.isLocal(shortcut)));
        clientRegion.setRegionName(this.getRegionName());
        clientRegion.setShortcut(shortcut);
        clientRegion.afterPropertiesSet();
        return clientRegion.getObject();
    }

    protected Interest<K>[] registerInterests(boolean register) {
        Interest[] interestArray;
        if (!register) {
            interestArray = new Interest[]{};
        } else {
            Interest[] interestArray2 = new Interest[1];
            interestArray = interestArray2;
            interestArray2[0] = new Interest((Object)"ALL_KEYS", InterestResultPolicy.KEYS);
        }
        return interestArray;
    }

    public Region<K, V> getObject() throws Exception {
        return this.region;
    }

    public Class<?> getObjectType() {
        return this.region != null ? this.region.getClass() : Region.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setClientRegionShortcut(ClientRegionShortcut clientRegionShortcut) {
        this.clientRegionShortcut = clientRegionShortcut;
    }

    protected ClientRegionShortcut getClientRegionShortcut() {
        return this.clientRegionShortcut != null ? this.clientRegionShortcut : DEFAULT_CLIENT_REGION_SHORTCUT;
    }

    public void setGemfireCache(GemFireCache gemfireCache) {
        Assert.notNull((Object)gemfireCache, (String)"The GemFireCache reference must not be null");
        this.gemfireCache = gemfireCache;
    }

    protected GemFireCache getGemfireCache() {
        Assert.state((this.gemfireCache != null ? 1 : 0) != 0, (String)"A reference to a GemFireCache was not properly configured");
        return this.gemfireCache;
    }

    public void setRegionAttributes(RegionAttributes<K, V> regionAttributes) {
        this.regionAttributes = regionAttributes;
    }

    protected RegionAttributes<K, V> getRegionAttributes() {
        return this.regionAttributes;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    protected String getRegionName() {
        return StringUtils.hasText((String)this.regionName) ? this.regionName : DEFAULT_SPRING_SESSION_GEMFIRE_REGION_NAME;
    }

    public void setServerRegionShortcut(RegionShortcut serverRegionShortcut) {
        this.serverRegionShortcut = serverRegionShortcut;
    }

    protected RegionShortcut getServerRegionShortcut() {
        return this.serverRegionShortcut != null ? this.serverRegionShortcut : DEFAULT_SERVER_REGION_SHORTCUT;
    }
}

