/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.redis;

import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.session.ExpiringSession;
import org.springframework.session.data.redis.RedisOperationsSessionRepository;

final class RedisSessionExpirationPolicy {
    private static final Log logger = LogFactory.getLog(RedisOperationsSessionRepository.class);
    static final String EXPIRATION_BOUNDED_HASH_KEY_PREFIX = "spring:session:expirations:";
    private final RedisOperations<String, ExpiringSession> sessionRedisOperations;
    private final RedisOperations<String, String> expirationRedisOperations;

    public RedisSessionExpirationPolicy(RedisOperations sessionRedisOperations) {
        this.sessionRedisOperations = sessionRedisOperations;
        this.expirationRedisOperations = sessionRedisOperations;
    }

    public void onDelete(ExpiringSession session) {
        long toExpire = RedisSessionExpirationPolicy.roundUpToNextMinute(RedisSessionExpirationPolicy.expiresInMillis(session));
        String expireKey = this.getExpirationKey(toExpire);
        this.expirationRedisOperations.boundSetOps((Object)expireKey).remove(new Object[]{session.getId()});
    }

    public void onExpirationUpdated(Long originalExpirationTimeInMilli, ExpiringSession session) {
        String expireKey;
        if (originalExpirationTimeInMilli != null) {
            long originalRoundedUp = RedisSessionExpirationPolicy.roundUpToNextMinute(originalExpirationTimeInMilli);
            expireKey = this.getExpirationKey(originalRoundedUp);
            this.expirationRedisOperations.boundSetOps((Object)expireKey).remove(new Object[]{session.getId()});
        }
        long toExpire = RedisSessionExpirationPolicy.roundUpToNextMinute(RedisSessionExpirationPolicy.expiresInMillis(session));
        expireKey = this.getExpirationKey(toExpire);
        BoundSetOperations expireOperations = this.expirationRedisOperations.boundSetOps((Object)expireKey);
        expireOperations.add((Object[])new String[]{session.getId()});
        long sessionExpireInSeconds = session.getMaxInactiveIntervalInSeconds();
        String sessionKey = this.getSessionKey(session.getId());
        expireOperations.expire(sessionExpireInSeconds + 60L, TimeUnit.SECONDS);
        this.sessionRedisOperations.boundHashOps((Object)sessionKey).expire(sessionExpireInSeconds, TimeUnit.SECONDS);
    }

    String getExpirationKey(long expires) {
        return EXPIRATION_BOUNDED_HASH_KEY_PREFIX + expires;
    }

    String getSessionKey(String sessionId) {
        return "spring:session:sessions:" + sessionId;
    }

    public void cleanExpiredSessions() {
        long now = System.currentTimeMillis();
        long prevMin = RedisSessionExpirationPolicy.roundDownMinute(now);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Cleaning up sessions expiring at " + new Date(prevMin)));
        }
        String expirationKey = this.getExpirationKey(prevMin);
        Set sessionsToExpire = this.expirationRedisOperations.boundSetOps((Object)expirationKey).members();
        this.expirationRedisOperations.delete((Object)expirationKey);
        for (String session : sessionsToExpire) {
            String sessionKey = this.getSessionKey(session);
            this.touch(sessionKey);
        }
    }

    private void touch(String key) {
        this.sessionRedisOperations.hasKey((Object)key);
    }

    static long expiresInMillis(ExpiringSession session) {
        int maxInactiveInSeconds = session.getMaxInactiveIntervalInSeconds();
        long lastAccessedTimeInMillis = session.getLastAccessedTime();
        return lastAccessedTimeInMillis + TimeUnit.SECONDS.toMillis(maxInactiveInSeconds);
    }

    static long roundUpToNextMinute(long timeInMs) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs);
        date.add(12, 1);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }

    static long roundDownMinute(long timeInMs) {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(timeInMs);
        date.clear(13);
        date.clear(14);
        return date.getTimeInMillis();
    }
}

