/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.retry.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.springframework.classify.SubclassClassifier;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.annotation.Recover;
import org.springframework.retry.interceptor.MethodInvocationRecoverer;
import org.springframework.util.ReflectionUtils;

public class RecoverAnnotationRecoveryHandler<T>
implements MethodInvocationRecoverer<T> {
    private SubclassClassifier<Throwable, Method> classifier = new SubclassClassifier();
    private Map<Method, SimpleMetadata> methods = new HashMap<Method, SimpleMetadata>();
    private Object target;

    public RecoverAnnotationRecoveryHandler(Object target, Method method) {
        this.target = target;
        this.init(target, method);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T recover(Object[] args, Throwable cause) {
        Method method = this.findClosestMatch(args, cause.getClass());
        if (method == null) {
            throw new ExhaustedRetryException("Cannot locate recovery method", cause);
        }
        SimpleMetadata meta = this.methods.get(method);
        Object[] argsToUse = meta.getArgs(cause, args);
        boolean methodAccessible = method.isAccessible();
        try {
            Object result;
            ReflectionUtils.makeAccessible((Method)method);
            Object object = result = ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])argsToUse);
            return (T)object;
        }
        finally {
            if (methodAccessible != method.isAccessible()) {
                method.setAccessible(methodAccessible);
            }
        }
    }

    private Method findClosestMatch(Object[] args, Class<? extends Throwable> cause) {
        int min = Integer.MAX_VALUE;
        Method result = null;
        for (Method method : this.methods.keySet()) {
            boolean parametersMatch;
            SimpleMetadata meta = this.methods.get(method);
            Class<? extends Throwable> type = meta.getType();
            if (type == null) {
                type = Throwable.class;
            }
            if (!type.isAssignableFrom(cause)) continue;
            int distance = this.calculateDistance(cause, type);
            if (distance < min) {
                min = distance;
                result = method;
                continue;
            }
            if (distance != min || !(parametersMatch = this.compareParameters(args, meta.getArgCount(), method.getParameterTypes()))) continue;
            result = method;
        }
        return result;
    }

    private int calculateDistance(Class<? extends Throwable> cause, Class<? extends Throwable> type) {
        int result = 0;
        for (Class<? extends Throwable> current = cause; current != type && current != Throwable.class; current = current.getSuperclass()) {
            ++result;
        }
        return result;
    }

    private boolean compareParameters(Object[] args, int argCount, Class<?>[] parameterTypes) {
        if (argCount == args.length + 1) {
            int startingIndex = 0;
            if (parameterTypes.length > 0 && parameterTypes[0] == Throwable.class) {
                startingIndex = 1;
            }
            for (int i = startingIndex; i < parameterTypes.length; ++i) {
                Object argument = args[i - 1];
                if (argument == null || parameterTypes[i] == argument.getClass()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void init(Object target, Method method) {
        final HashMap types = new HashMap();
        final Method failingMethod = method;
        ReflectionUtils.doWithMethods(failingMethod.getDeclaringClass(), (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                Recover recover = (Recover)AnnotationUtils.findAnnotation((Method)method, Recover.class);
                if (recover != null && method.getReturnType().isAssignableFrom(failingMethod.getReturnType())) {
                    Class<?>[] parameterTypes = method.getParameterTypes();
                    if (parameterTypes.length > 0 && Throwable.class.isAssignableFrom(parameterTypes[0])) {
                        Class<?> type = parameterTypes[0];
                        types.put(type, method);
                        RecoverAnnotationRecoveryHandler.this.methods.put(method, new SimpleMetadata(parameterTypes.length, type));
                    } else {
                        RecoverAnnotationRecoveryHandler.this.classifier.setDefaultValue(method);
                        RecoverAnnotationRecoveryHandler.this.methods.put(method, new SimpleMetadata(parameterTypes.length, null));
                    }
                }
            }
        });
        this.classifier.setTypeMap(types);
        this.optionallyFilterMethodsBy(failingMethod.getReturnType());
    }

    private void optionallyFilterMethodsBy(Class<?> returnClass) {
        HashMap<Method, SimpleMetadata> filteredMethods = new HashMap<Method, SimpleMetadata>();
        for (Method method : this.methods.keySet()) {
            if (method.getReturnType() != returnClass) continue;
            filteredMethods.put(method, this.methods.get(method));
        }
        if (filteredMethods.size() > 0) {
            this.methods = filteredMethods;
        }
    }

    private static class SimpleMetadata {
        private int argCount;
        private Class<? extends Throwable> type;

        public SimpleMetadata(int argCount, Class<? extends Throwable> type) {
            this.argCount = argCount;
            this.type = type;
        }

        public int getArgCount() {
            return this.argCount;
        }

        public Class<? extends Throwable> getType() {
            return this.type;
        }

        public Object[] getArgs(Throwable t, Object[] args) {
            Object[] result = new Object[this.getArgCount()];
            int startArgs = 0;
            if (this.type != null) {
                result[0] = t;
                startArgs = 1;
            }
            System.arraycopy(args, 0, result, startArgs, result.length - startArgs);
            return result;
        }
    }
}

