/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server.reactive;

import java.util.List;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.TemplateVariables;
import org.springframework.hateoas.server.core.DummyInvocationUtils;
import org.springframework.hateoas.server.core.LinkBuilderSupport;
import org.springframework.hateoas.server.core.TemplateVariableAwareLinkBuilderSupport;
import org.springframework.hateoas.server.core.WebHandler;
import org.springframework.http.HttpRequest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.filter.reactive.ServerWebExchangeContextFilter;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WebFluxLinkBuilder
extends TemplateVariableAwareLinkBuilderSupport<WebFluxLinkBuilder> {
    private WebFluxLinkBuilder(UriComponentsBuilder builder, TemplateVariables variables, List<Affordance> affordances) {
        super(builder, variables, affordances);
    }

    private WebFluxLinkBuilder(UriComponents components, TemplateVariables variables, List<Affordance> affordances) {
        super(components, variables, affordances);
    }

    public static WebFluxBuilder linkTo(Object invocation) {
        Assert.notNull((Object)invocation, (String)"Invocation must not be null!");
        return new WebFluxBuilder(WebFluxLinkBuilder.linkToInternal(invocation));
    }

    public static WebFluxBuilder linkTo(Object invocation, ServerWebExchange exchange) {
        return new WebFluxBuilder(WebFluxLinkBuilder.linkToInternal(invocation, (Mono<UriComponentsBuilder>)Mono.just((Object)WebFluxLinkBuilder.getBuilder(exchange))));
    }

    public static <T> T methodOn(Class<T> controller, Object ... parameters) {
        return DummyInvocationUtils.methodOn(controller, parameters);
    }

    @Override
    protected WebFluxLinkBuilder createNewInstance(UriComponentsBuilder builder, List<Affordance> affordances, TemplateVariables variables) {
        return new WebFluxLinkBuilder(builder, variables, affordances);
    }

    @Override
    protected WebFluxLinkBuilder getThis() {
        return this;
    }

    private static UriComponentsBuilder getBuilder(@Nullable ServerWebExchange exchange) {
        return exchange == null ? UriComponentsBuilder.fromPath((String)"/") : UriComponentsBuilder.fromHttpRequest((HttpRequest)exchange.getRequest());
    }

    private static Mono<WebFluxLinkBuilder> linkToInternal(Object invocation) {
        return WebFluxLinkBuilder.linkToInternal(invocation, (Mono<UriComponentsBuilder>)Mono.subscriberContext().map(context -> WebFluxLinkBuilder.getBuilder((ServerWebExchange)context.getOrDefault((Object)ServerWebExchangeContextFilter.EXCHANGE_CONTEXT_ATTRIBUTE, null))));
    }

    private static Mono<WebFluxLinkBuilder> linkToInternal(Object invocation, Mono<UriComponentsBuilder> exchange) {
        Function<Function<String, UriComponentsBuilder>, WebFluxLinkBuilder> linkTo = WebHandler.linkTo(invocation, WebFluxLinkBuilder::new);
        return exchange.map(WebFluxLinkBuilder::getBuilderCreator).map(linkTo);
    }

    private static Function<String, UriComponentsBuilder> getBuilderCreator(UriComponentsBuilder exchange) {
        return path -> exchange.replacePath(path == null ? "/" : path);
    }

    public static class WebFluxLink {
        private final Mono<Link> link;

        public WebFluxLink andAffordance(Object invocation) {
            Assert.notNull((Object)invocation, (String)"Invocation must not be null!");
            Mono builder = WebFluxLinkBuilder.linkToInternal(invocation);
            return new WebFluxLink((Mono<Link>)this.link.flatMap(it -> builder.flatMapIterable(LinkBuilderSupport::getAffordances).singleOrEmpty().map(it::andAffordance)));
        }

        public WebFluxLink map(Function<Link, Link> mapper) {
            Assert.notNull(mapper, (String)"Function must not be null!");
            return new WebFluxLink((Mono<Link>)this.link.map(mapper));
        }

        public Mono<Link> toMono() {
            return this.link;
        }

        public Mono<Link> toMono(Function<Link, Link> finisher) {
            Assert.notNull(finisher, (String)"Function must not be null!");
            return this.link.map(finisher);
        }

        @Generated
        public WebFluxLink(Mono<Link> link) {
            this.link = link;
        }
    }

    public static class WebFluxBuilder {
        private final Mono<WebFluxLinkBuilder> builder;

        public WebFluxLink withRel(LinkRelation relation) {
            return new WebFluxLink((Mono<Link>)this.builder.map(it -> it.withRel(relation)));
        }

        public WebFluxLink withRel(String relation) {
            return new WebFluxLink((Mono<Link>)this.builder.map(it -> it.withRel(relation)));
        }

        public WebFluxLink withSelfRel() {
            return new WebFluxLink((Mono<Link>)this.builder.map(LinkBuilderSupport::withSelfRel));
        }

        public WebFluxLink toLink(Function<WebFluxLinkBuilder, Mono<Link>> finisher) {
            Assert.notNull(finisher, (String)"Finisher must not be null!");
            return new WebFluxLink((Mono<Link>)this.builder.flatMap(finisher));
        }

        @Generated
        public WebFluxBuilder(Mono<WebFluxLinkBuilder> builder) {
            this.builder = builder;
        }
    }
}

