/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.server;

import java.util.ArrayList;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.util.Assert;

public interface SimpleRepresentationModelAssembler<T>
extends RepresentationModelAssembler<T, EntityModel<T>> {
    @Override
    default public EntityModel<T> toModel(T entity) {
        EntityModel<T> resource = new EntityModel<T>(entity, new Link[0]);
        this.addLinks(resource);
        return resource;
    }

    public void addLinks(EntityModel<T> var1);

    @Override
    default public CollectionModel<EntityModel<T>> toCollectionModel(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"entities must not be null!");
        ArrayList<RepresentationModel> resourceList = new ArrayList<RepresentationModel>();
        for (T entity : entities) {
            resourceList.add(this.toModel((Object)entity));
        }
        CollectionModel<EntityModel<T>> resources = new CollectionModel<EntityModel<T>>(resourceList, new Link[0]);
        this.addLinks(resources);
        return resources;
    }

    public void addLinks(CollectionModel<EntityModel<T>> var1);
}

