/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.hateoas.core.MappingDiscoverer;
import org.springframework.util.Assert;

public class AnnotationMappingDiscoverer
implements MappingDiscoverer {
    private final Class<? extends Annotation> annotationType;
    private final String mappingAttributeName;

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation) {
        this(annotation, null);
    }

    public AnnotationMappingDiscoverer(Class<? extends Annotation> annotation, String mappingAttributeName) {
        Assert.notNull(annotation);
        this.annotationType = annotation;
        this.mappingAttributeName = mappingAttributeName;
    }

    @Override
    public String getMapping(Class<?> type) {
        String[] mapping = this.getMappingFrom(AnnotationUtils.findAnnotation(type, this.annotationType));
        if (mapping.length > 1) {
            throw new IllegalStateException(String.format("Multiple class level mappings defined on class %s!", type.getName()));
        }
        return mapping.length == 0 ? null : mapping[0];
    }

    @Override
    public String getMapping(Method method) {
        String[] mapping = this.getMappingFrom(AnnotationUtils.findAnnotation((Method)method, this.annotationType));
        if (mapping.length > 1) {
            throw new IllegalStateException(String.format("Multiple method level mappings defined on method %s!", method.toString()));
        }
        String typeMapping = this.getMapping(method.getDeclaringClass());
        return typeMapping == null ? mapping[0] : typeMapping + mapping[0];
    }

    private String[] getMappingFrom(Annotation annotation) {
        Object value;
        Object object = value = this.mappingAttributeName == null ? AnnotationUtils.getValue((Annotation)annotation) : AnnotationUtils.getValue((Annotation)annotation, (String)this.mappingAttributeName);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value == null) {
            return new String[0];
        }
        throw new IllegalStateException(String.format("Unsupported type for the mapping attribute! Support String and String[] but got %s!", value.getClass()));
    }
}

