/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas.alps;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.List;
import org.springframework.hateoas.alps.Doc;
import org.springframework.hateoas.alps.Ext;
import org.springframework.hateoas.alps.Type;

@JsonPropertyOrder(value={"id", "href", "name", "type", "doc", "descriptor", "ext"})
public final class Descriptor {
    private final String id;
    private final String href;
    private final String name;
    private final Doc doc;
    private final Type type;
    private final Ext ext;
    private final String rt;
    @JsonProperty(value="descriptor")
    private final List<Descriptor> descriptors;

    Descriptor(String id, String href, String name, Doc doc, Type type, Ext ext, String rt, List<Descriptor> descriptors) {
        this.id = id;
        this.href = href;
        this.name = name;
        this.doc = doc;
        this.type = type;
        this.ext = ext;
        this.rt = rt;
        this.descriptors = descriptors;
    }

    public static DescriptorBuilder builder() {
        return new DescriptorBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getHref() {
        return this.href;
    }

    public String getName() {
        return this.name;
    }

    public Doc getDoc() {
        return this.doc;
    }

    public Type getType() {
        return this.type;
    }

    public Ext getExt() {
        return this.ext;
    }

    public String getRt() {
        return this.rt;
    }

    public List<Descriptor> getDescriptors() {
        return this.descriptors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Descriptor)) {
            return false;
        }
        Descriptor other = (Descriptor)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$href = this.getHref();
        String other$href = other.getHref();
        if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Doc this$doc = this.getDoc();
        Doc other$doc = other.getDoc();
        if (this$doc == null ? other$doc != null : !((Object)this$doc).equals(other$doc)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Ext this$ext = this.getExt();
        Ext other$ext = other.getExt();
        if (this$ext == null ? other$ext != null : !((Object)this$ext).equals(other$ext)) {
            return false;
        }
        String this$rt = this.getRt();
        String other$rt = other.getRt();
        if (this$rt == null ? other$rt != null : !this$rt.equals(other$rt)) {
            return false;
        }
        List<Descriptor> this$descriptors = this.getDescriptors();
        List<Descriptor> other$descriptors = other.getDescriptors();
        return !(this$descriptors == null ? other$descriptors != null : !((Object)this$descriptors).equals(other$descriptors));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $href = this.getHref();
        result = result * 59 + ($href == null ? 43 : $href.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Doc $doc = this.getDoc();
        result = result * 59 + ($doc == null ? 43 : ((Object)$doc).hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Ext $ext = this.getExt();
        result = result * 59 + ($ext == null ? 43 : ((Object)$ext).hashCode());
        String $rt = this.getRt();
        result = result * 59 + ($rt == null ? 43 : $rt.hashCode());
        List<Descriptor> $descriptors = this.getDescriptors();
        result = result * 59 + ($descriptors == null ? 43 : ((Object)$descriptors).hashCode());
        return result;
    }

    public String toString() {
        return "Descriptor(id=" + this.getId() + ", href=" + this.getHref() + ", name=" + this.getName() + ", doc=" + this.getDoc() + ", type=" + (Object)((Object)this.getType()) + ", ext=" + this.getExt() + ", rt=" + this.getRt() + ", descriptors=" + this.getDescriptors() + ")";
    }

    public static class DescriptorBuilder {
        private String id;
        private String href;
        private String name;
        private Doc doc;
        private Type type;
        private Ext ext;
        private String rt;
        private List<Descriptor> descriptors;

        DescriptorBuilder() {
        }

        public DescriptorBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DescriptorBuilder href(String href) {
            this.href = href;
            return this;
        }

        public DescriptorBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DescriptorBuilder doc(Doc doc) {
            this.doc = doc;
            return this;
        }

        public DescriptorBuilder type(Type type) {
            this.type = type;
            return this;
        }

        public DescriptorBuilder ext(Ext ext) {
            this.ext = ext;
            return this;
        }

        public DescriptorBuilder rt(String rt) {
            this.rt = rt;
            return this;
        }

        public DescriptorBuilder descriptors(List<Descriptor> descriptors) {
            this.descriptors = descriptors;
            return this;
        }

        public Descriptor build() {
            return new Descriptor(this.id, this.href, this.name, this.doc, this.type, this.ext, this.rt, this.descriptors);
        }

        public String toString() {
            return "Descriptor.DescriptorBuilder(id=" + this.id + ", href=" + this.href + ", name=" + this.name + ", doc=" + this.doc + ", type=" + (Object)((Object)this.type) + ", ext=" + this.ext + ", rt=" + this.rt + ", descriptors=" + this.descriptors + ")";
        }
    }
}

