/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.boot.context.properties.ConfigurationPropertiesBean;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinder;
import org.springframework.boot.context.properties.ConfigurationPropertiesValueObjectBeanDefinition;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;

class ConfigurationPropertiesBeanDefinitionValidator
implements BeanFactoryPostProcessor,
Ordered {
    private static final String BEAN_NAME = ConfigurationPropertiesBeanDefinitionValidator.class.getName();

    ConfigurationPropertiesBeanDefinitionValidator() {
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            if (beanFactory.containsSingleton(beanName) || this.isValueObjectBeanDefinition(beanFactory, beanName)) continue;
            this.validate(beanFactory, beanName);
        }
    }

    private boolean isValueObjectBeanDefinition(ConfigurableListableBeanFactory beanFactory, String beanName) {
        BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
        return definition instanceof ConfigurationPropertiesValueObjectBeanDefinition;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private void validate(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Class beanClass = beanFactory.getType(beanName, false);
        if (beanClass != null && ConfigurationPropertiesBean.BindMethod.forType(beanClass) == ConfigurationPropertiesBean.BindMethod.VALUE_OBJECT) {
            throw new BeanCreationException(beanName, "@EnableConfigurationProperties or @ConfigurationPropertiesScan must be used to add @ConstructorBinding type " + beanClass.getName());
        }
    }

    static void register(BeanDefinitionRegistry registry) {
        Assert.notNull((Object)registry, (String)"Registry must not be null");
        if (!registry.containsBeanDefinition(BEAN_NAME)) {
            GenericBeanDefinition definition = new GenericBeanDefinition();
            definition.setBeanClass(ConfigurationPropertiesBeanDefinitionValidator.class);
            definition.setRole(2);
            registry.registerBeanDefinition(BEAN_NAME, (BeanDefinition)definition);
        }
        ConfigurationPropertiesBinder.register(registry);
    }
}

