/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.bind;

import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.context.properties.bind.BeanBinder;
import org.springframework.boot.context.properties.bind.BeanPropertyBinder;
import org.springframework.boot.context.properties.bind.BeanPropertyName;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.context.properties.source.ConfigurationPropertyState;
import org.springframework.core.MethodParameter;
import org.springframework.core.ResolvableType;

class JavaBeanBinder
implements BeanBinder {
    JavaBeanBinder() {
    }

    @Override
    public <T> T bind(ConfigurationPropertyName name, Bindable<T> target, Binder.Context context, BeanPropertyBinder propertyBinder) {
        boolean hasKnownBindableProperties = this.hasKnownBindableProperties(name, context);
        Bean<T> bean = Bean.get(target, hasKnownBindableProperties);
        if (bean == null) {
            return null;
        }
        BeanSupplier<T> beanSupplier = bean.getSupplier(target);
        boolean bound = this.bind(propertyBinder, bean, beanSupplier);
        return bound ? (T)beanSupplier.get() : null;
    }

    private boolean hasKnownBindableProperties(ConfigurationPropertyName name, Binder.Context context) {
        for (ConfigurationPropertySource source : context.getSources()) {
            if (source.containsDescendantOf(name) != ConfigurationPropertyState.PRESENT) continue;
            return true;
        }
        return false;
    }

    private <T> boolean bind(BeanPropertyBinder propertyBinder, Bean<T> bean, BeanSupplier<T> beanSupplier) {
        boolean bound = false;
        for (BeanProperty beanProperty : bean.getProperties().values()) {
            bound |= this.bind(beanSupplier, propertyBinder, beanProperty);
        }
        return bound;
    }

    private <T> boolean bind(BeanSupplier<T> beanSupplier, BeanPropertyBinder propertyBinder, BeanProperty property) {
        String propertyName = property.getName();
        ResolvableType type = property.getType();
        Supplier<Object> value = property.getValue(beanSupplier);
        Annotation[] annotations = property.getAnnotations();
        Object bound = propertyBinder.bindProperty(propertyName, Bindable.of(type).withSuppliedValue(value).withAnnotations(annotations));
        if (bound == null) {
            return false;
        }
        if (property.isSettable()) {
            property.setValue(beanSupplier, bound);
        } else if (value == null || !bound.equals(value.get())) {
            throw new IllegalStateException("No setter found for property: " + property.getName());
        }
        return true;
    }

    static class BeanProperty {
        private final String name;
        private final ResolvableType declaringClassType;
        private Method getter;
        private Method setter;
        private Field field;

        BeanProperty(String name, ResolvableType declaringClassType) {
            this.name = BeanPropertyName.toDashedForm(name);
            this.declaringClassType = declaringClassType;
        }

        public void addGetter(Method getter) {
            if (this.getter == null) {
                this.getter = getter;
            }
        }

        public void addSetter(Method setter) {
            if (this.setter == null || this.isBetterSetter(setter)) {
                this.setter = setter;
            }
        }

        private boolean isBetterSetter(Method setter) {
            return this.getter != null && this.getter.getReturnType().equals(setter.getParameterTypes()[0]);
        }

        public void addField(Field field) {
            if (this.field == null) {
                this.field = field;
            }
        }

        public String getName() {
            return this.name;
        }

        public ResolvableType getType() {
            if (this.setter != null) {
                MethodParameter methodParameter = new MethodParameter(this.setter, 0);
                return ResolvableType.forMethodParameter((MethodParameter)methodParameter, (ResolvableType)this.declaringClassType);
            }
            MethodParameter methodParameter = new MethodParameter(this.getter, -1);
            return ResolvableType.forMethodParameter((MethodParameter)methodParameter, (ResolvableType)this.declaringClassType);
        }

        public Annotation[] getAnnotations() {
            try {
                return this.field != null ? this.field.getDeclaredAnnotations() : null;
            }
            catch (Exception ex) {
                return null;
            }
        }

        public Supplier<Object> getValue(Supplier<?> instance) {
            if (this.getter == null) {
                return null;
            }
            return () -> {
                try {
                    this.getter.setAccessible(true);
                    return this.getter.invoke(instance.get(), new Object[0]);
                }
                catch (Exception ex) {
                    throw new IllegalStateException("Unable to get value for property " + this.name, ex);
                }
            };
        }

        public boolean isSettable() {
            return this.setter != null;
        }

        public void setValue(Supplier<?> instance, Object value) {
            try {
                this.setter.setAccessible(true);
                this.setter.invoke(instance.get(), value);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to set value for property " + this.name, ex);
            }
        }
    }

    private static class BeanSupplier<T>
    implements Supplier<T> {
        private final Supplier<T> factory;
        private T instance;

        BeanSupplier(Supplier<T> factory) {
            this.factory = factory;
        }

        @Override
        public T get() {
            if (this.instance == null) {
                this.instance = this.factory.get();
            }
            return this.instance;
        }
    }

    static class Bean<T> {
        private static Bean<?> cached;
        private final ResolvableType type;
        private final Class<?> resolvedType;
        private final Map<String, BeanProperty> properties = new LinkedHashMap<String, BeanProperty>();

        Bean(ResolvableType type, Class<?> resolvedType) {
            this.type = type;
            this.resolvedType = resolvedType;
            this.addProperties(resolvedType);
        }

        private void addProperties(Class<?> type) {
            while (type != null && !Object.class.equals(type)) {
                Method[] declaredMethods = type.getDeclaredMethods();
                Field[] declaredFields = type.getDeclaredFields();
                this.addProperties(declaredMethods, declaredFields);
                type = type.getSuperclass();
            }
        }

        protected void addProperties(Method[] declaredMethods, Field[] declaredFields) {
            for (int i = 0; i < declaredMethods.length; ++i) {
                if (this.isCandidate(declaredMethods[i])) continue;
                declaredMethods[i] = null;
            }
            for (Method method : declaredMethods) {
                this.addMethodIfPossible(method, "get", 0, BeanProperty::addGetter);
            }
            for (Method method : declaredMethods) {
                this.addMethodIfPossible(method, "is", 0, BeanProperty::addGetter);
                this.addMethodIfPossible(method, "set", 1, BeanProperty::addSetter);
            }
            for (AccessibleObject accessibleObject : declaredFields) {
                this.addField((Field)accessibleObject);
            }
        }

        private boolean isCandidate(Method method) {
            int modifiers = method.getModifiers();
            return Modifier.isPublic(modifiers) && !Modifier.isAbstract(modifiers) && !Modifier.isStatic(modifiers) && !Object.class.equals(method.getDeclaringClass()) && !Class.class.equals(method.getDeclaringClass());
        }

        private void addMethodIfPossible(Method method, String prefix, int parameterCount, BiConsumer<BeanProperty, Method> consumer) {
            if (method != null && method.getParameterCount() == parameterCount && method.getName().startsWith(prefix) && method.getName().length() > prefix.length()) {
                String propertyName = Introspector.decapitalize(method.getName().substring(prefix.length()));
                consumer.accept(this.properties.computeIfAbsent(propertyName, this::getBeanProperty), method);
            }
        }

        private BeanProperty getBeanProperty(String name) {
            return new BeanProperty(name, this.type);
        }

        private void addField(Field field) {
            BeanProperty property = this.properties.get(field.getName());
            if (property != null) {
                property.addField(field);
            }
        }

        public Map<String, BeanProperty> getProperties() {
            return this.properties;
        }

        public BeanSupplier<T> getSupplier(Bindable<T> target) {
            return new BeanSupplier<Object>(() -> {
                Object instance = null;
                if (target.getValue() != null) {
                    instance = target.getValue().get();
                }
                if (instance == null) {
                    instance = BeanUtils.instantiateClass(this.resolvedType);
                }
                return instance;
            });
        }

        private boolean isOfDifferentType(ResolvableType targetType) {
            if (this.type.hasGenerics() || targetType.hasGenerics()) {
                return !this.type.equals((Object)targetType);
            }
            return this.resolvedType == null || !this.resolvedType.equals(targetType.resolve());
        }

        public static <T> Bean<T> get(Bindable<T> bindable, boolean canCallGetValue) {
            ResolvableType type = bindable.getType();
            Class<?> resolvedType = type.resolve(Object.class);
            Supplier<T> value = bindable.getValue();
            Object instance = null;
            if (canCallGetValue && value != null) {
                instance = value.get();
                Class<?> clazz = resolvedType = instance != null ? instance.getClass() : resolvedType;
            }
            if (instance == null && !Bean.isInstantiable(resolvedType)) {
                return null;
            }
            Bean<Object> bean = cached;
            if (bean == null || super.isOfDifferentType(type)) {
                cached = bean = new Bean<T>(type, resolvedType);
            }
            return bean;
        }

        private static boolean isInstantiable(Class<?> type) {
            if (type.isInterface()) {
                return false;
            }
            try {
                type.getDeclaredConstructor(new Class[0]);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

