/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.servlet;

import java.util.Map;
import javax.servlet.annotation.WebServlet;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.embedded.ServletRegistrationBean;
import org.springframework.boot.web.servlet.ServletComponentHandler;
import org.springframework.util.StringUtils;

class WebServletHandler
extends ServletComponentHandler {
    WebServletHandler() {
        super(WebServlet.class);
    }

    @Override
    public void doHandle(Map<String, Object> attributes, BeanDefinition beanDefinition, BeanDefinitionRegistry registry) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(ServletRegistrationBean.class);
        builder.addPropertyValue("asyncSupported", attributes.get("asyncSupported"));
        builder.addPropertyValue("initParameters", this.extractInitParameters(attributes));
        builder.addPropertyValue("loadOnStartup", attributes.get("loadOnStartup"));
        String name = this.determineName(attributes, beanDefinition);
        builder.addPropertyValue("name", (Object)name);
        builder.addPropertyValue("servlet", (Object)beanDefinition);
        builder.addPropertyValue("urlMappings", (Object)this.extractUrlPatterns("urlPatterns", attributes));
        registry.registerBeanDefinition(name, (BeanDefinition)builder.getBeanDefinition());
    }

    private String determineName(Map<String, Object> attributes, BeanDefinition beanDefinition) {
        return (String)(StringUtils.hasText((String)((String)attributes.get("name"))) ? attributes.get("name") : beanDefinition.getBeanClassName());
    }
}

