/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test;

import java.lang.reflect.AnnotatedElement;
import org.springframework.boot.test.IntegrationTest;
import org.springframework.boot.test.MergedContextConfigurationProperties;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.util.ReflectionTestUtils;

public class IntegrationTestPropertiesListener
extends AbstractTestExecutionListener {
    public void prepareTestInstance(TestContext testContext) throws Exception {
        Class testClass = testContext.getTestClass();
        AnnotationAttributes annotationAttributes = AnnotatedElementUtils.getMergedAnnotationAttributes((AnnotatedElement)testClass, (String)IntegrationTest.class.getName());
        if (annotationAttributes != null) {
            this.addPropertySourceProperties(testContext, annotationAttributes.getStringArray("value"));
        }
    }

    private void addPropertySourceProperties(TestContext testContext, String[] properties) {
        try {
            MergedContextConfiguration configuration = (MergedContextConfiguration)ReflectionTestUtils.getField((Object)testContext, (String)"mergedContextConfiguration");
            new MergedContextConfigurationProperties(configuration).add(properties, new String[0]);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }
}

