/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.ApplicationPid;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.context.event.ApplicationEnvironmentPreparedEvent;
import org.springframework.boot.context.event.ApplicationStartedEvent;
import org.springframework.boot.logging.LogLevel;
import org.springframework.boot.logging.LoggingSystem;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.ClassUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ResourceUtils;
import org.springframework.util.StringUtils;

public class LoggingApplicationListener
implements SmartApplicationListener {
    private static final Map<String, String> ENVIRONMENT_SYSTEM_PROPERTY_MAPPING = new HashMap<String, String>();
    public static final String PID_KEY = "PID";
    private static MultiValueMap<LogLevel, String> LOG_LEVEL_LOGGERS;
    private static Class<?>[] EVENT_TYPES;
    private final Log logger = LogFactory.getLog(this.getClass());
    private int order = -2147483637;
    private boolean parseArgs = true;
    private LogLevel springBootLogging = null;

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        for (Class<? extends ApplicationEvent> clazz : EVENT_TYPES) {
            if (!clazz.isAssignableFrom(eventType)) continue;
            return true;
        }
        return false;
    }

    public boolean supportsSourceType(Class<?> sourceType) {
        return SpringApplication.class.isAssignableFrom(sourceType);
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ApplicationEnvironmentPreparedEvent) {
            ApplicationEnvironmentPreparedEvent available = (ApplicationEnvironmentPreparedEvent)event;
            this.initialize(available.getEnvironment(), available.getSpringApplication().getClassLoader());
        } else {
            if (System.getProperty(PID_KEY) == null) {
                System.setProperty(PID_KEY, new ApplicationPid().toString());
            }
            LoggingSystem loggingSystem = LoggingSystem.get(ClassUtils.getDefaultClassLoader());
            loggingSystem.beforeInitialize();
        }
    }

    protected void initialize(ConfigurableEnvironment environment, ClassLoader classLoader) {
        if (this.parseArgs && this.springBootLogging == null) {
            if (environment.containsProperty("debug")) {
                this.springBootLogging = LogLevel.DEBUG;
            }
            if (environment.containsProperty("trace")) {
                this.springBootLogging = LogLevel.TRACE;
            }
        }
        if (!StringUtils.hasLength((String)System.getProperty("LOG_TEMP"))) {
            String path = System.getProperty("java.io.tmpdir");
            if ((path = StringUtils.cleanPath((String)path)).endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            System.setProperty("LOG_TEMP", path);
        }
        boolean environmentChanged = false;
        for (Map.Entry<String, String> mapping : ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.entrySet()) {
            if (!environment.containsProperty(mapping.getKey())) continue;
            System.setProperty(mapping.getValue(), environment.getProperty(mapping.getKey()));
            environmentChanged = true;
        }
        LoggingSystem system = LoggingSystem.get(classLoader);
        if (environmentChanged) {
            system.beforeInitialize();
        }
        if (environment.containsProperty("logging.config")) {
            String value = environment.getProperty("logging.config");
            try {
                ResourceUtils.getURL((String)value).openStream().close();
                system.initialize(value);
                return;
            }
            catch (Exception ex) {
                this.logger.warn((Object)("Logging environment value '" + value + "' cannot be opened and will be ignored"));
            }
        }
        system.initialize();
        if (this.springBootLogging != null) {
            this.initializeLogLevel(system, this.springBootLogging);
        }
    }

    protected void initializeLogLevel(LoggingSystem system, LogLevel level) {
        List loggers = (List)LOG_LEVEL_LOGGERS.get((Object)level);
        if (loggers != null) {
            for (String logger : loggers) {
                system.setLogLevel(logger, level);
            }
        }
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setSpringBootLogging(LogLevel springBootLogging) {
        this.springBootLogging = springBootLogging;
    }

    public void setParseArgs(boolean parseArgs) {
        this.parseArgs = parseArgs;
    }

    static {
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put("logging.file", "LOG_FILE");
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put("logging.path", "LOG_PATH");
        ENVIRONMENT_SYSTEM_PROPERTY_MAPPING.put(PID_KEY, PID_KEY);
        LOG_LEVEL_LOGGERS = new LinkedMultiValueMap();
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.DEBUG, (Object)"org.springframework.boot");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.springframework");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.apache.tomcat");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.eclipse.jetty");
        LOG_LEVEL_LOGGERS.add((Object)LogLevel.TRACE, (Object)"org.hibernate.tool.hbm2ddl");
        EVENT_TYPES = new Class[]{ApplicationStartedEvent.class, ApplicationEnvironmentPreparedEvent.class};
    }
}

