/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.embedded.tomcat;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Container;
import org.apache.catalina.Engine;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.startup.Tomcat;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.context.embedded.EmbeddedServletContainer;
import org.springframework.boot.context.embedded.EmbeddedServletContainerException;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedContext;
import org.springframework.util.Assert;

public class TomcatEmbeddedServletContainer
implements EmbeddedServletContainer {
    private final Log logger = LogFactory.getLog(TomcatEmbeddedServletContainer.class);
    private static AtomicInteger containerCounter = new AtomicInteger(-1);
    private final Tomcat tomcat;
    private final boolean autoStart;

    public TomcatEmbeddedServletContainer(Tomcat tomcat) {
        this(tomcat, true);
    }

    public TomcatEmbeddedServletContainer(Tomcat tomcat, boolean autoStart) {
        Assert.notNull((Object)tomcat, (String)"Tomcat Server must not be null");
        this.tomcat = tomcat;
        this.autoStart = autoStart;
        this.initialize();
    }

    private synchronized void initialize() throws EmbeddedServletContainerException {
        try {
            int instanceId = containerCounter.incrementAndGet();
            if (instanceId > 0) {
                Engine engine = this.tomcat.getEngine();
                engine.setName(engine.getName() + "-" + instanceId);
            }
            this.tomcat.start();
            try {
                Connector connector = this.tomcat.getConnector();
                connector.getProtocolHandler().stop();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Cannot pause connector: ", (Throwable)ex);
            }
            Thread awaitThread = new Thread("container-" + containerCounter.get()){

                @Override
                public void run() {
                    TomcatEmbeddedServletContainer.this.tomcat.getServer().await();
                }
            };
            awaitThread.setDaemon(false);
            awaitThread.start();
            if (LifecycleState.FAILED.equals((Object)this.tomcat.getConnector().getState())) {
                this.tomcat.stop();
                throw new IllegalStateException("Tomcat connector in failed state");
            }
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to start embedded Tomcat", ex);
        }
    }

    @Override
    public void start() throws EmbeddedServletContainerException {
        Connector connector = this.tomcat.getConnector();
        if (connector != null && this.autoStart) {
            try {
                for (Container child : this.tomcat.getHost().findChildren()) {
                    if (!(child instanceof TomcatEmbeddedContext)) continue;
                    ((TomcatEmbeddedContext)child).deferredLoadOnStartup();
                }
                connector.getProtocolHandler().start();
                this.logPorts();
            }
            catch (Exception ex) {
                this.logger.error((Object)"Cannot start connector: ", (Throwable)ex);
                throw new EmbeddedServletContainerException("Unable to start embedded Tomcat connectors", ex);
            }
        }
    }

    private void logPorts() {
        StringBuilder ports = new StringBuilder();
        for (Connector additionalConnector : this.tomcat.getService().findConnectors()) {
            ports.append(ports.length() == 0 ? "" : " ");
            ports.append(additionalConnector.getLocalPort() + "/" + additionalConnector.getScheme());
        }
        this.logger.info((Object)("Tomcat started on port(s): " + ports.toString()));
    }

    @Override
    public synchronized void stop() throws EmbeddedServletContainerException {
        try {
            try {
                this.tomcat.stop();
            }
            catch (LifecycleException ex) {
                // empty catch block
            }
            this.tomcat.destroy();
        }
        catch (Exception ex) {
            throw new EmbeddedServletContainerException("Unable to stop embedded Tomcat", ex);
        }
        finally {
            containerCounter.decrementAndGet();
        }
    }

    @Override
    public int getPort() {
        Connector connector = this.tomcat.getConnector();
        if (connector != null) {
            return connector.getLocalPort();
        }
        return 0;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }
}

