/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import org.springframework.core.io.ClassPathResource;

public class FilteredClassLoader
extends URLClassLoader {
    private final Collection<Predicate<String>> classesFilters;
    private final Collection<Predicate<String>> resourcesFilters;

    public FilteredClassLoader(Class<?> ... hiddenClasses) {
        this(Collections.singleton(ClassFilter.of(hiddenClasses)), Collections.emptyList());
    }

    public FilteredClassLoader(String ... hiddenPackages) {
        this(Collections.singleton(PackageFilter.of(hiddenPackages)), Collections.emptyList());
    }

    public FilteredClassLoader(ClassPathResource ... hiddenResources) {
        this(Collections.emptyList(), Collections.singleton(ClassPathResourceFilter.of(hiddenResources)));
    }

    @SafeVarargs
    public FilteredClassLoader(Predicate<String> ... filters) {
        this(Arrays.asList(filters), Arrays.asList(filters));
    }

    private FilteredClassLoader(Collection<Predicate<String>> classesFilters, Collection<Predicate<String>> resourcesFilters) {
        super(new URL[0], FilteredClassLoader.class.getClassLoader());
        this.classesFilters = classesFilters;
        this.resourcesFilters = resourcesFilters;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        for (Predicate<String> filter : this.classesFilters) {
            if (!filter.test(name)) continue;
            throw new ClassNotFoundException();
        }
        return super.loadClass(name, resolve);
    }

    @Override
    public URL getResource(String name) {
        for (Predicate<String> filter : this.resourcesFilters) {
            if (!filter.test(name)) continue;
            return null;
        }
        return super.getResource(name);
    }

    public static final class ClassPathResourceFilter
    implements Predicate<String> {
        private final ClassPathResource[] hiddenResources;

        private ClassPathResourceFilter(ClassPathResource[] hiddenResources) {
            this.hiddenResources = hiddenResources;
        }

        @Override
        public boolean test(String resourceName) {
            for (ClassPathResource hiddenResource : this.hiddenResources) {
                if (hiddenResource.getFilename() == null || !resourceName.equals(hiddenResource.getPath())) continue;
                return true;
            }
            return false;
        }

        public static ClassPathResourceFilter of(ClassPathResource ... hiddenResources) {
            return new ClassPathResourceFilter(hiddenResources);
        }
    }

    public static final class PackageFilter
    implements Predicate<String> {
        private final String[] hiddenPackages;

        private PackageFilter(String[] hiddenPackages) {
            this.hiddenPackages = hiddenPackages;
        }

        @Override
        public boolean test(String className) {
            for (String hiddenPackage : this.hiddenPackages) {
                if (!className.startsWith(hiddenPackage)) continue;
                return true;
            }
            return false;
        }

        public static PackageFilter of(String ... hiddenPackages) {
            return new PackageFilter(hiddenPackages);
        }
    }

    public static final class ClassFilter
    implements Predicate<String> {
        private Class<?>[] hiddenClasses;

        private ClassFilter(Class<?>[] hiddenClasses) {
            this.hiddenClasses = hiddenClasses;
        }

        @Override
        public boolean test(String className) {
            for (Class<?> hiddenClass : this.hiddenClasses) {
                if (!className.equals(hiddenClass.getName())) continue;
                return true;
            }
            return false;
        }

        public static ClassFilter of(Class<?> ... hiddenClasses) {
            return new ClassFilter(hiddenClasses);
        }
    }
}

