/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.web.reactive.server;

import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanDefinitionRegistryPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.web.codec.CodecCustomizer;
import org.springframework.boot.web.reactive.server.AbstractReactiveWebServerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.http.codec.CodecConfigurer;
import org.springframework.test.context.ContextCustomizer;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.test.web.reactive.server.WebTestClient;
import org.springframework.util.CollectionUtils;
import org.springframework.web.reactive.function.client.ExchangeStrategies;

class WebTestClientContextCustomizer
implements ContextCustomizer {
    WebTestClientContextCustomizer() {
    }

    public void customizeContext(ConfigurableApplicationContext context, MergedContextConfiguration mergedConfig) {
        SpringBootTest annotation = (SpringBootTest)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)mergedConfig.getTestClass(), SpringBootTest.class);
        if (annotation.webEnvironment().isEmbedded()) {
            this.registerWebTestClient(context);
        }
    }

    private void registerWebTestClient(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        if (beanFactory instanceof BeanDefinitionRegistry) {
            this.registerWebTestClient((BeanDefinitionRegistry)beanFactory);
        }
    }

    private void registerWebTestClient(BeanDefinitionRegistry registry) {
        RootBeanDefinition definition = new RootBeanDefinition(WebTestClientRegistrar.class);
        definition.setRole(2);
        registry.registerBeanDefinition(WebTestClientRegistrar.class.getName(), (BeanDefinition)definition);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass() == this.getClass();
    }

    public int hashCode() {
        return this.getClass().hashCode();
    }

    public static class WebTestClientFactory
    implements FactoryBean<WebTestClient>,
    ApplicationContextAware {
        private ApplicationContext applicationContext;
        private WebTestClient object;

        public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
            this.applicationContext = applicationContext;
        }

        public boolean isSingleton() {
            return true;
        }

        public Class<?> getObjectType() {
            return WebTestClient.class;
        }

        public WebTestClient getObject() throws Exception {
            if (this.object == null) {
                this.object = this.createWebTestClient();
            }
            return this.object;
        }

        private WebTestClient createWebTestClient() {
            boolean sslEnabled = this.isSslEnabled(this.applicationContext);
            String port = this.applicationContext.getEnvironment().getProperty("local.server.port", "8080");
            String baseUrl = (sslEnabled ? "https" : "http") + "://localhost:" + port;
            WebTestClient.Builder builder = WebTestClient.bindToServer();
            this.customizeWebTestClientCodecs(builder, this.applicationContext);
            return builder.baseUrl(baseUrl).build();
        }

        private boolean isSslEnabled(ApplicationContext context) {
            try {
                AbstractReactiveWebServerFactory webServerFactory = (AbstractReactiveWebServerFactory)context.getBean(AbstractReactiveWebServerFactory.class);
                return webServerFactory.getSsl() != null && webServerFactory.getSsl().isEnabled();
            }
            catch (NoSuchBeanDefinitionException ex) {
                return false;
            }
        }

        private void customizeWebTestClientCodecs(WebTestClient.Builder clientBuilder, ApplicationContext context) {
            Collection codecCustomizers = context.getBeansOfType(CodecCustomizer.class).values();
            if (!CollectionUtils.isEmpty(codecCustomizers)) {
                clientBuilder.exchangeStrategies(ExchangeStrategies.builder().codecs(codecs -> codecCustomizers.forEach(codecCustomizer -> codecCustomizer.customize((CodecConfigurer)codecs))).build());
            }
        }
    }

    private static class WebTestClientRegistrar
    implements BeanDefinitionRegistryPostProcessor,
    Ordered,
    BeanFactoryAware {
        private BeanFactory beanFactory;

        private WebTestClientRegistrar() {
        }

        public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
            this.beanFactory = beanFactory;
        }

        public int getOrder() {
            return Integer.MAX_VALUE;
        }

        public void postProcessBeanDefinitionRegistry(BeanDefinitionRegistry registry) throws BeansException {
            if (BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)((ListableBeanFactory)this.beanFactory), WebTestClient.class).length == 0) {
                registry.registerBeanDefinition(WebTestClient.class.getName(), (BeanDefinition)new RootBeanDefinition(WebTestClientFactory.class));
            }
        }

        public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        }
    }
}

