/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.orm.jpa;

import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.springframework.orm.jpa.EntityManagerFactoryUtils;
import org.springframework.util.Assert;

public class TestEntityManager {
    private final EntityManagerFactory entityManagerFactory;

    public TestEntityManager(EntityManagerFactory entityManagerFactory) {
        Assert.notNull((Object)entityManagerFactory, (String)"EntityManagerFactory must not be null");
        this.entityManagerFactory = entityManagerFactory;
    }

    public Object persistAndGetId(Object entity) {
        this.persist(entity);
        return this.getId(entity);
    }

    public <T> T persistAndGetId(Object entity, Class<T> idType) {
        this.persist(entity);
        return this.getId(entity, idType);
    }

    public <E> E persist(E entity) {
        Assert.state((this.getId(entity) == null ? 1 : 0) != 0, (String)("Entity " + entity.getClass().getName() + " already has an ID"));
        this.getEntityManager().persist(entity);
        return entity;
    }

    public <E> E persistFlushFind(E entity) {
        EntityManager entityManager = this.getEntityManager();
        this.persistAndFlush(entity);
        Object id = this.getId(entity);
        entityManager.detach(entity);
        return (E)entityManager.find(entity.getClass(), id);
    }

    public <E> E persistAndFlush(E entity) {
        this.persist(entity);
        this.flush();
        return entity;
    }

    public <E> E merge(E entity) {
        return (E)this.getEntityManager().merge(entity);
    }

    public void remove(Object entity) {
        this.getEntityManager().remove(entity);
    }

    public <E> E find(Class<E> entityClass, Object primaryKey) {
        return (E)this.getEntityManager().find(entityClass, primaryKey);
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public <E> E refresh(E entity) {
        this.getEntityManager().refresh(entity);
        return entity;
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    public void detach(Object entity) {
        this.getEntityManager().detach(entity);
    }

    public Object getId(Object entity) {
        return this.entityManagerFactory.getPersistenceUnitUtil().getIdentifier(entity);
    }

    public <T> T getId(Object entity, Class<T> idType) {
        Object id = this.getId(entity);
        Assert.isInstanceOf(idType, (Object)id, (String)"ID mismatch");
        return (T)id;
    }

    public final EntityManager getEntityManager() {
        EntityManager manager = EntityManagerFactoryUtils.getTransactionalEntityManager((EntityManagerFactory)this.entityManagerFactory);
        Assert.state((manager != null ? 1 : 0) != 0, (String)"No transactional EntityManager found");
        return manager;
    }
}

