/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.maven;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.collection.AbstractArtifactFeatureFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;
import org.springframework.boot.loader.tools.FileUtils;
import org.springframework.boot.loader.tools.MainClassFinder;
import org.springframework.boot.maven.AbstractDependencyFilterMojo;
import org.springframework.boot.maven.RunArguments;

public abstract class AbstractRunMojo
extends AbstractDependencyFilterMojo {
    private static final String SPRING_BOOT_APPLICATION_CLASS_NAME = "org.springframework.boot.autoconfigure.SpringBootApplication";
    private static final String SPRING_LOADED_AGENT_CLASS_NAME = "org.springsource.loaded.agent.SpringLoadedAgent";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(property="run.addResources", defaultValue="false")
    private boolean addResources = false;
    @Parameter(property="run.agent")
    private File[] agent;
    @Parameter(property="run.noverify")
    private Boolean noverify;
    @Parameter(property="run.workingDirectory")
    private File workingDirectory;
    @Parameter(property="run.jvmArguments")
    private String jvmArguments;
    @Parameter(property="run.arguments")
    private String[] arguments;
    @Parameter(property="run.profiles")
    private String[] profiles;
    @Parameter
    private String mainClass;
    @Parameter
    private String[] folders;
    @Parameter(defaultValue="${project.build.outputDirectory}", required=true)
    private File classesDirectory;
    @Parameter(property="fork")
    private Boolean fork;
    @Parameter(property="useTestClasspath", defaultValue="false")
    private Boolean useTestClasspath;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"skipping run as per configuration.");
            return;
        }
        this.run(this.getStartClass());
    }

    protected boolean isFork() {
        return Boolean.TRUE.equals(this.fork) || this.fork == null && this.enableForkByDefault();
    }

    protected boolean enableForkByDefault() {
        return this.hasAgent() || this.hasJvmArgs() || this.hasWorkingDirectorySet();
    }

    private boolean hasAgent() {
        return this.agent != null && this.agent.length > 0;
    }

    private boolean hasJvmArgs() {
        return this.jvmArguments != null && this.jvmArguments.length() > 0;
    }

    private boolean hasWorkingDirectorySet() {
        return this.workingDirectory != null;
    }

    private void findAgent() {
        try {
            Class<?> loaded;
            if ((this.agent == null || this.agent.length == 0) && (loaded = Class.forName(SPRING_LOADED_AGENT_CLASS_NAME)) != null) {
                CodeSource source;
                if (this.noverify == null) {
                    this.noverify = true;
                }
                if ((source = loaded.getProtectionDomain().getCodeSource()) != null) {
                    this.agent = new File[]{new File(source.getLocation().getFile())};
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (this.noverify == null) {
            this.noverify = false;
        }
    }

    private void run(String startClassName) throws MojoExecutionException, MojoFailureException {
        this.findAgent();
        boolean fork = this.isFork();
        this.project.getProperties().setProperty("_spring.boot.fork.enabled", Boolean.toString(fork));
        if (fork) {
            this.doRunWithForkedJvm(startClassName);
        } else {
            this.logDisabledFork();
            this.runWithMavenJvm(startClassName, this.resolveApplicationArguments().asArray());
        }
    }

    protected void logDisabledFork() {
        if (this.hasAgent()) {
            this.getLog().warn((CharSequence)"Fork mode disabled, ignoring agent");
        }
        if (this.hasJvmArgs()) {
            this.getLog().warn((CharSequence)("Fork mode disabled, ignoring JVM argument(s) [" + this.jvmArguments + "]"));
        }
        if (this.hasWorkingDirectorySet()) {
            this.getLog().warn((CharSequence)"Fork mode disabled, ignoring working directory configuration");
        }
    }

    private void doRunWithForkedJvm(String startClassName) throws MojoExecutionException, MojoFailureException {
        ArrayList<String> args = new ArrayList<String>();
        this.addAgents(args);
        this.addJvmArgs(args);
        this.addClasspath(args);
        args.add(startClassName);
        this.addArgs(args);
        this.runWithForkedJvm(this.workingDirectory, args);
    }

    protected abstract void runWithForkedJvm(File var1, List<String> var2) throws MojoExecutionException, MojoFailureException;

    protected abstract void runWithMavenJvm(String var1, String ... var2) throws MojoExecutionException, MojoFailureException;

    protected RunArguments resolveApplicationArguments() {
        RunArguments runArguments = new RunArguments(this.arguments);
        this.addActiveProfileArgument(runArguments);
        return runArguments;
    }

    private void addArgs(List<String> args) {
        RunArguments applicationArguments = this.resolveApplicationArguments();
        Collections.addAll(args, applicationArguments.asArray());
        this.logArguments("Application argument(s): ", this.arguments);
    }

    protected RunArguments resolveJvmArguments() {
        return new RunArguments(this.jvmArguments);
    }

    private void addJvmArgs(List<String> args) {
        RunArguments jvmArguments = this.resolveJvmArguments();
        Collections.addAll(args, jvmArguments.asArray());
        this.logArguments("JVM argument(s): ", jvmArguments.asArray());
    }

    private void addAgents(List<String> args) {
        if (this.agent != null) {
            this.getLog().info((CharSequence)("Attaching agents: " + Arrays.asList(this.agent)));
            for (File agent : this.agent) {
                args.add("-javaagent:" + agent);
            }
        }
        if (this.noverify.booleanValue()) {
            args.add("-noverify");
        }
    }

    private void addActiveProfileArgument(RunArguments arguments) {
        if (this.profiles.length > 0) {
            StringBuilder arg = new StringBuilder("--spring.profiles.active=");
            for (int i = 0; i < this.profiles.length; ++i) {
                arg.append(this.profiles[i]);
                if (i >= this.profiles.length - 1) continue;
                arg.append(",");
            }
            arguments.getArgs().addFirst(arg.toString());
            this.logArguments("Active profile(s): ", this.profiles);
        }
    }

    private void addClasspath(List<String> args) throws MojoExecutionException {
        try {
            StringBuilder classpath = new StringBuilder();
            for (URL ele : this.getClassPathUrls()) {
                classpath = classpath.append((classpath.length() > 0 ? File.pathSeparator : "") + new File(ele.toURI()));
            }
            this.getLog().debug((CharSequence)("Classpath for forked process: " + classpath));
            args.add("-cp");
            args.add(classpath.toString());
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Could not build classpath", ex);
        }
    }

    private String getStartClass() throws MojoExecutionException {
        String mainClass = this.mainClass;
        if (mainClass == null) {
            try {
                mainClass = MainClassFinder.findSingleMainClass((File)this.classesDirectory, (String)SPRING_BOOT_APPLICATION_CLASS_NAME);
            }
            catch (IOException ex) {
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        if (mainClass == null) {
            throw new MojoExecutionException("Unable to find a suitable main class, please add a 'mainClass' property");
        }
        return mainClass;
    }

    protected URL[] getClassPathUrls() throws MojoExecutionException {
        try {
            ArrayList<URL> urls = new ArrayList<URL>();
            this.addUserDefinedFolders(urls);
            this.addResources(urls);
            this.addProjectClasses(urls);
            this.addDependencies(urls);
            return urls.toArray(new URL[urls.size()]);
        }
        catch (MalformedURLException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
        catch (IOException ex) {
            throw new MojoExecutionException("Unable to build classpath", (Exception)ex);
        }
    }

    private void addUserDefinedFolders(List<URL> urls) throws MalformedURLException {
        if (this.folders != null) {
            for (String folder : this.folders) {
                urls.add(new File(folder).toURI().toURL());
            }
        }
    }

    private void addResources(List<URL> urls) throws IOException {
        if (this.addResources) {
            for (Resource resource : this.project.getResources()) {
                File directory = new File(resource.getDirectory());
                urls.add(directory.toURI().toURL());
                FileUtils.removeDuplicatesFromOutputDirectory((File)this.classesDirectory, (File)directory);
            }
        }
    }

    private void addProjectClasses(List<URL> urls) throws MalformedURLException {
        urls.add(this.classesDirectory.toURI().toURL());
    }

    private void addDependencies(List<URL> urls) throws MalformedURLException, MojoExecutionException {
        FilterArtifacts filters = this.useTestClasspath != false ? this.getFilters(new ArtifactsFilter[0]) : this.getFilters(new ArtifactsFilter[]{new TestArtifactFilter()});
        Set<Artifact> artifacts = this.filterDependencies(this.project.getArtifacts(), filters);
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            urls.add(artifact.getFile().toURI().toURL());
        }
    }

    private void logArguments(String message, String[] args) {
        StringBuilder sb = new StringBuilder(message);
        for (String arg : args) {
            sb.append(arg).append(" ");
        }
        this.getLog().debug((CharSequence)sb.toString().trim());
    }

    class LaunchRunner
    implements Runnable {
        private final String startClassName;
        private final String[] args;

        LaunchRunner(String startClassName, String ... args) {
            this.startClassName = startClassName;
            this.args = args != null ? args : new String[]{};
        }

        @Override
        public void run() {
            Thread thread = Thread.currentThread();
            ClassLoader classLoader = thread.getContextClassLoader();
            try {
                Class<?> startClass = classLoader.loadClass(this.startClassName);
                Method mainMethod = startClass.getMethod("main", String[].class);
                if (!mainMethod.isAccessible()) {
                    mainMethod.setAccessible(true);
                }
                mainMethod.invoke(null, new Object[]{this.args});
            }
            catch (NoSuchMethodException ex) {
                Exception wrappedEx = new Exception("The specified mainClass doesn't contain a main method with appropriate signature.", ex);
                thread.getThreadGroup().uncaughtException(thread, wrappedEx);
            }
            catch (Exception ex) {
                thread.getThreadGroup().uncaughtException(thread, ex);
            }
        }
    }

    class IsolatedThreadGroup
    extends ThreadGroup {
        private final Object monitor;
        private Throwable exception;

        IsolatedThreadGroup(String name) {
            super(name);
            this.monitor = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable ex) {
            if (!(ex instanceof ThreadDeath)) {
                Object object = this.monitor;
                synchronized (object) {
                    this.exception = this.exception == null ? ex : this.exception;
                }
                AbstractRunMojo.this.getLog().warn(ex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rethrowUncaughtException() throws MojoExecutionException {
            Object object = this.monitor;
            synchronized (object) {
                if (this.exception != null) {
                    throw new MojoExecutionException("An exception occurred while running. " + this.exception.getMessage(), this.exception);
                }
            }
        }
    }

    private static class TestArtifactFilter
    extends AbstractArtifactFeatureFilter {
        TestArtifactFilter() {
            super("", "test");
        }

        protected String getArtifactFeature(Artifact artifact) {
            return artifact.getScope();
        }
    }
}

