/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.springframework.boot.devtools.settings.DevToolsSettings;
import org.springframework.util.StringUtils;

final class ChangeableUrls
implements Iterable<URL> {
    private final List<URL> urls;

    private ChangeableUrls(URL ... urls) {
        DevToolsSettings settings = DevToolsSettings.get();
        ArrayList<URL> reloadableUrls = new ArrayList<URL>(urls.length);
        for (URL url : urls) {
            if (!settings.isRestartInclude(url) && !this.isFolderUrl(url.toString()) || settings.isRestartExclude(url)) continue;
            reloadableUrls.add(url);
        }
        this.urls = Collections.unmodifiableList(reloadableUrls);
    }

    private boolean isFolderUrl(String urlString) {
        return urlString.startsWith("file:") && urlString.endsWith("/");
    }

    @Override
    public Iterator<URL> iterator() {
        return this.urls.iterator();
    }

    public int size() {
        return this.urls.size();
    }

    public URL[] toArray() {
        return this.urls.toArray(new URL[this.urls.size()]);
    }

    public List<URL> toList() {
        return Collections.unmodifiableList(this.urls);
    }

    public String toString() {
        return this.urls.toString();
    }

    public static ChangeableUrls fromUrlClassLoader(URLClassLoader classLoader) {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (URL url : classLoader.getURLs()) {
            urls.add(url);
            urls.addAll(ChangeableUrls.getUrlsFromClassPathOfJarManifestIfPossible(url));
        }
        return ChangeableUrls.fromUrls(urls);
    }

    private static List<URL> getUrlsFromClassPathOfJarManifestIfPossible(URL url) {
        JarFile jarFile = ChangeableUrls.getJarFileIfPossible(url);
        if (jarFile == null) {
            return Collections.emptyList();
        }
        try {
            return ChangeableUrls.getUrlsFromClassPathAttribute(url, jarFile.getManifest());
        }
        catch (IOException ex) {
            throw new IllegalStateException("Failed to read Class-Path attribute from manifest of jar " + url, ex);
        }
    }

    private static JarFile getJarFileIfPossible(URL url) {
        try {
            File file = new File(url.toURI());
            if (file.isFile()) {
                return new JarFile(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static List<URL> getUrlsFromClassPathAttribute(URL base, Manifest manifest) {
        if (manifest == null) {
            return Collections.emptyList();
        }
        String classPath = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
        if (!StringUtils.hasText((String)classPath)) {
            return Collections.emptyList();
        }
        String[] entries = StringUtils.delimitedListToStringArray((String)classPath, (String)" ");
        ArrayList<URL> urls = new ArrayList<URL>(entries.length);
        for (String entry : entries) {
            try {
                urls.add(new URL(base, entry));
            }
            catch (MalformedURLException ex) {
                throw new IllegalStateException("Class-Path attribute contains malformed URL", ex);
            }
        }
        return urls;
    }

    public static ChangeableUrls fromUrls(Collection<URL> urls) {
        return ChangeableUrls.fromUrls(new ArrayList<URL>(urls).toArray(new URL[urls.size()]));
    }

    public static ChangeableUrls fromUrls(URL ... urls) {
        return new ChangeableUrls(urls);
    }
}

