/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.autoconfigure;

import javax.annotation.PostConstruct;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.DefaultDeserializer;
import org.springframework.core.serializer.Deserializer;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.util.ObjectUtils;

class RestartCompatibleRedisSerializerConfigurer
implements BeanClassLoaderAware {
    private final RedisTemplate<?, ?> redisTemplate;
    private volatile ClassLoader classLoader;

    RestartCompatibleRedisSerializerConfigurer(RedisTemplate<?, ?> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @PostConstruct
    void configureTemplateSerializers() {
        RestartCompatibleRedisSerializer serializer = new RestartCompatibleRedisSerializer(this.classLoader);
        this.redisTemplate.setHashKeySerializer((RedisSerializer)serializer);
        this.redisTemplate.setHashValueSerializer((RedisSerializer)serializer);
        this.redisTemplate.setKeySerializer((RedisSerializer)serializer);
        this.redisTemplate.setValueSerializer((RedisSerializer)serializer);
    }

    static class RestartCompatibleRedisSerializer
    implements RedisSerializer<Object> {
        private static final byte[] NO_BYTES = new byte[0];
        private final Converter<Object, byte[]> serializer = new SerializingConverter();
        private final Converter<byte[], Object> deserializer;

        RestartCompatibleRedisSerializer(ClassLoader classLoader) {
            this.deserializer = new DeserializingConverter((Deserializer)new DefaultDeserializer(classLoader));
        }

        public Object deserialize(byte[] bytes) {
            try {
                return ObjectUtils.isEmpty((Object)bytes) ? null : this.deserializer.convert((Object)bytes);
            }
            catch (Exception ex) {
                throw new SerializationException("Cannot deserialize", (Throwable)ex);
            }
        }

        public byte[] serialize(Object object) {
            try {
                return object == null ? NO_BYTES : (byte[])this.serializer.convert(object);
            }
            catch (Exception ex) {
                throw new SerializationException("Cannot serialize", (Throwable)ex);
            }
        }
    }
}

