/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.mustache;

import com.samskivert.mustache.DefaultCollector;
import com.samskivert.mustache.Mustache;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;

public class MustacheEnvironmentCollector
extends DefaultCollector
implements EnvironmentAware {
    private ConfigurableEnvironment environment;
    private final Mustache.VariableFetcher propertyFetcher = new PropertyVariableFetcher();

    public void setEnvironment(Environment environment) {
        this.environment = (ConfigurableEnvironment)environment;
    }

    public Mustache.VariableFetcher createFetcher(Object ctx, String name) {
        Mustache.VariableFetcher fetcher = super.createFetcher(ctx, name);
        if (fetcher != null) {
            return fetcher;
        }
        if (this.environment.containsProperty(name)) {
            return this.propertyFetcher;
        }
        return null;
    }

    private class PropertyVariableFetcher
    implements Mustache.VariableFetcher {
        private PropertyVariableFetcher() {
        }

        public Object get(Object ctx, String name) throws Exception {
            return MustacheEnvironmentCollector.this.environment.getProperty(name);
        }
    }
}

