/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.session;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.autoconfigure.session.SessionStoreMappings;
import org.springframework.boot.autoconfigure.session.StoreType;
import org.springframework.boot.bind.RelaxedPropertyResolver;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.env.PropertyResolver;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.ClassUtils;

class SessionCondition
extends SpringBootCondition {
    private static final boolean redisPresent = ClassUtils.isPresent((String)"org.springframework.data.redis.core.RedisTemplate", (ClassLoader)SessionCondition.class.getClassLoader());

    SessionCondition() {
    }

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        RelaxedPropertyResolver resolver = new RelaxedPropertyResolver((PropertyResolver)context.getEnvironment(), "spring.session.");
        StoreType sessionStoreType = SessionStoreMappings.getType(((AnnotationMetadata)metadata).getClassName());
        if (!resolver.containsProperty("store-type")) {
            if (sessionStoreType == StoreType.REDIS && redisPresent) {
                return ConditionOutcome.match("Session store type default to redis (deprecated)");
            }
            return ConditionOutcome.noMatch("Session store type not set");
        }
        String value = resolver.getProperty("store-type").replace("-", "_").toUpperCase();
        if (value.equals(sessionStoreType.name())) {
            return ConditionOutcome.match("Session store type " + (Object)((Object)sessionStoreType));
        }
        return ConditionOutcome.noMatch("Session store type " + value);
    }
}

