/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.social;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.social.LinkedInProperties;
import org.springframework.boot.autoconfigure.social.SocialAutoConfigurerAdapter;
import org.springframework.boot.autoconfigure.social.SocialWebAutoConfiguration;
import org.springframework.boot.autoconfigure.web.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.social.config.annotation.EnableSocial;
import org.springframework.social.config.annotation.SocialConfigurerAdapter;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.ConnectionFactory;
import org.springframework.social.connect.ConnectionRepository;
import org.springframework.social.connect.web.GenericConnectionStatusView;
import org.springframework.social.linkedin.api.LinkedIn;
import org.springframework.social.linkedin.connect.LinkedInConnectionFactory;

@Configuration
@ConditionalOnClass(value={SocialConfigurerAdapter.class, LinkedInConnectionFactory.class})
@ConditionalOnProperty(prefix="spring.social.linkedin", name={"app-id"})
@AutoConfigureBefore(value={SocialWebAutoConfiguration.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class LinkedInAutoConfiguration {

    @Configuration
    @EnableSocial
    @EnableConfigurationProperties(value={LinkedInProperties.class})
    @ConditionalOnWebApplication
    protected static class LinkedInConfigurerAdapter
    extends SocialAutoConfigurerAdapter {
        @Autowired
        private LinkedInProperties properties;

        protected LinkedInConfigurerAdapter() {
        }

        @Bean
        @ConditionalOnMissingBean(value={LinkedIn.class})
        @Scope(value="request", proxyMode=ScopedProxyMode.INTERFACES)
        public LinkedIn linkedin(ConnectionRepository repository) {
            Connection connection = repository.findPrimaryConnection(LinkedIn.class);
            return connection != null ? (LinkedIn)connection.getApi() : null;
        }

        @Bean(name={"connect/linkedinConnect", "connect/linkedinConnected"})
        @ConditionalOnProperty(prefix="spring.social", name={"auto-connection-views"})
        public GenericConnectionStatusView linkedInConnectView() {
            return new GenericConnectionStatusView("linkedin", "LinkedIn");
        }

        @Override
        protected ConnectionFactory<?> createConnectionFactory() {
            return new LinkedInConnectionFactory(this.properties.getAppId(), this.properties.getAppSecret());
        }
    }
}

