/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.sendgrid;

import com.sendgrid.SendGrid;
import org.apache.http.HttpHost;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.sendgrid.SendGridProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={SendGrid.class})
@ConditionalOnProperty(prefix="spring.sendgrid", value={"username"})
@EnableConfigurationProperties(value={SendGridProperties.class})
public class SendGridAutoConfiguration {
    @Autowired
    private SendGridProperties properties;

    @Bean
    @ConditionalOnMissingBean(value={SendGrid.class})
    public SendGrid sendGrid() {
        SendGrid sendGrid = new SendGrid(this.properties.getUsername(), this.properties.getPassword());
        if (this.properties.isProxyConfigured()) {
            HttpHost proxy = new HttpHost(this.properties.getProxy().getHost(), this.properties.getProxy().getPort().intValue());
            sendGrid.setClient(HttpClientBuilder.create().setProxy(proxy).setUserAgent("sendgrid/" + sendGrid.getVersion() + ";java").build());
        }
        return sendGrid;
    }
}

